@extends($activeTemplate . 'layouts.frontend2')
@section('content')
    <section class="pt-80 pb-80">
        <div class="container">
            
            <h3 class="card-title text-center">
               Formular Programare Intalnire <br> {{ __($service->title) }}
            </h3>
            <div class="row d-flex justify-content-center mb-4">
                <div class="col-lg-3 text-center">
                    <a href="{{ route('influencer.profile', [slug($service->influencer->username), $service->influencer->id]) }}">
                        <span class="position-relative mr10">
                            <img class="rounded-circle"
                                src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                alt="Freelancer Photo"
                                style="width: 40px; height: 40px;">
                            <span class="online-badge"></span>
                        </span>
                        <span
                            class="fz14">{{ __(@$service->influencer->username) }}</span>
                    </a>
                </div>
            </div>
            <form action="{{ route('user.order.confirm', [$influencer->id, $service->id]) }}" method="POST">
                @csrf
                <div class="row gy-3">

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="form-label">@lang('Request Title') </label>
                            <input type="text" name="title" class="form-control form--control" value="{{ old('title') }}" required>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="form-label">@lang('Estimated Delivery Date') </label>
                            <input type="text" class="datepicker-here form-control form--control" data-language='en' data-date-format="yyyy-mm-dd" data-position='bottom left' placeholder="@lang('Select Date')" name="delivery_date" autocomplete="off" required>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label">@lang('Influencer')</label>
                            <input type="text" class="form-control form--control" value="{{ __($influencer->fullname) }}" disabled>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label">@lang('Service Price')</label>
                            <div class="input-group">
                                <input type="text" step="any" class="form-control form--control" value="{{ showAmount($service->price) }}" disabled>
                                <span class="input-group-text">{{ $general->cur_text }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label">@lang('Payment Type')</label>
                            <select class="form-control form--control form-select" name="payment_type" required>
                                <option value="" disabled selected>@lang('Select One')</option>
                                <option value="2">@lang('Direct Payment')</option>
                                <option value="1">@lang('Deposited Wallet') ({{ showAmount(auth()->user()->balance) }} {{ $general->cur_text }})</option>
                            </select>
                        </div>
                    </div>


                    <div class="col-xl-12">
                        <div class="form-group">
                            <label class="form-label" for="description">@lang('Description')</label>
                            <textarea rows="6" class="form-control form--control " style="height:unset!important" name="description" id="description" placeholder="@lang('Description')">{{ old('description') }}</textarea>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <button type="submit" class="ud-btn btn-thm w-100">@lang('Confirm Order')</button>
                    </div>

                </div>
            </form>
        </div>
    </section>
@endsection
@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/datepicker.min.css') }}">
@endpush
@push('script-lib')
    <script src="{{ asset('assets/global/js/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/datepicker.en.js') }}"></script>
@endpush

@push('script')
    <script>
        $('.datepicker-here').datepicker({
            changeYear: true,
            changeMonth: true,
            minDate: new Date(),
        });
    </script>
@endpush
