@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'user.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <div class="packages_table table-responsive">
                                            <table class="table-style3 table at-savesearch">
                                                <thead class="thead">
                                                    <tr>
                                                        <th>@lang('Mentor')</th>
                                                        <th>@lang('Rating')</th>
                                                        <th>@lang('Dată Înscriere')</th>
                                                        <th>@lang('Acțiuni')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($favorites as $favorite)
                                                        <tr>
                                                            <td data-label="@lang('Mentor')">
                                                                <span class="fw-bold"><a
                                                                        href="{{ route('influencer.profile', [slug($favorite->influencer->username), $favorite->influencer_id]) }}"
                                                                        class="text--base">{{ __(@$favorite->influencer->username) }}</span>
                                                            </td>
                                                            <td data-label="@lang('Rating')" class="text-center">
                                                                <div>
                                                                    <span
                                                                        class="fw-bold">@php
                                                                        echo showRatings($favorite->influencer->rating);
                                                                        @endphp
                                                                        ({{ getAmount(@$favorite->influencer->reviews_count) }})
                                                                </div>
                                                            </td>
                                                            <td data-label="@lang('Dată Înscriere')">
                                                                <span>{{ showDateTime(@$favorite->influencer->created_at) }}</span>
                                                            </td>

                                                            <td data-label="@lang('Actiuni')">
                                                                <div class="d-flex flex-wrap gap-1 justify-content-end">
                                                                    <a href="{{ route('influencer.profile', [slug($favorite->influencer->username), $favorite->influencer_id]) }}"
                                                                        class="btn btn--sm btn--outline-base">
                                                                        <i class="fa-regular fa-eye"></i> @lang('Profil')
                                                                    </a>
                                                                    <a href="{{ route('user.favorite.remove', $favorite->id) }}"
                                                                        class="btn btn--sm btn--outline-info">
                                                                        <i class="fa-regular fa-circle-xmark" style="color: red;"></i> @lang('Șterge')
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td class="justify-content-center text-center" colspan="100%">
                                                                <i class="la la-4x la-frown"></i>
                                                                <br>
                                                                {{ __($emptyMessage) }}
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                            <canvas id="myChartweave" style="height:230px;"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="dashboard_footer pt30 pb30">
                            <div class="container">
                                <div class="row align-items-center justify-content-center justify-content-md-between">
                                    {{-- <div class="col-auto">
                  <div class="copyright-widget">
                    <p class="mb-md-0">© Freeio. 2023 CreativeLayers. All rights reserved.</p>
                  </div>
                </div> --}}
                                    <div class="col-12">
                                        <div class="footer_bottom_right_btns at-home8 text-center text-lg-end">
                                            <ul class="p-0 m-0">
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>US$ USD</option>
                                                        <option>Euro</option>
                                                        <option>Pound</option>
                                                    </select>
                                                </li>
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>English</option>
                                                        <option>Frenc</option>
                                                        <option>Italian</option>
                                                        <option>Spanish</option>
                                                        <option>Turkey</option>
                                                    </select>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>
                    </div>
                </div>
            </div>
            <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
        </div>
    </div>
@endsection
