@extends($activeTemplate . 'layouts.frontend2')
@section('content')
    @php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $register = getContent('user_register.content', true);
        $registerInfluencer = getContent('influencer_register.content', true);

    @endphp



    <section class="our-register">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 m-auto wow fadeInUp" data-wow-delay="300ms">
                    <div class="main-title text-center">
                        <h2 class="title">Register</h2>
                    </div>
                </div>
            </div>
            <div class="row wow fadeInRight" data-wow-delay="300ms">
                <div class="col-xl-6 mx-auto">
                    <div class="log-reg-form search-modal form-style1 bgc-white p50 p30-sm default-box-shadow1 bdrs12">
                        <div class="mb30">
                            <h4>Let's create your account!</h4>
                            <p class="text mt20">Already have an account? <a href="{{route('user.login')}}" class="text-thm">Log
                                    In!</a></p>
                        </div>


                        <form action="{{ route('user.register') }}" method="POST" class="form verify-gcaptcha">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb25">
                                    <div class="form-group">
                                        <label class="form-label fw500 dark-color" for="username">@lang('Username')</label>
                                        <input type="text" name="username" id="username"
                                            value="{{ old('username') }}" class="form-control form--control checkUser"
                                            required>
                                        <small class="text-danger usernameExist"></small>
                                    </div>
                                </div>
                                <div class="col-md-6 mb25">
                                    <div class="form-group">
                                        <label class="form-label fw500 dark-color" for="email">@lang('Email Address')</label>
                                        <input type="email" name="email" id="email"
                                            value="{{ old('email') }}" class="form-control form--control checkUser"
                                            required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb25">
                                    <label for="country" class="form-label fw500 dark-color">Tara</label>
                                    <select name="country" id="country" class="form-select form--control">
                                        @foreach ($countries as $key => $country)
                                            <option data-mobile_code="{{ $country->dial_code }}"
                                                value="{{ $country->country }}" data-code="{{ $key }}" @if($country->country == 'Romania') selected @endif>
                                                {{ __($country->country) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 mb25">
                                    <label class="form-label" for="mobile">@lang('Mobile')</label>
                                    <div class="input-group">
                                        <span class="input-group-text mobile-code"></span>
                                        <input type="hidden" name="mobile_code">
                                        <input type="hidden" name="country_code">
                                        <input type="number" name="mobile" value="{{ old('mobile') }}"
                                            class="form-control form--control checkUser" required>
                                    </div>
                                    <small class="text-danger mobileExist"></small>
                                </div>
                                <div class="col-md-6 mb15">
                                    <label class="form-label" for="password">@lang('Password')</label>
                                    <input type="password" id="password" name="password" class="form-control form--control"
                                        required>
                                    @if ($general->secure_password)
                                        <div class="input-popup">
                                            <p class="error lower">@lang('1 small letter minimum')</p>
                                            <p class="error capital">@lang('1 capital letter minimum')</p>
                                            <p class="error number">@lang('1 number minimum')</p>
                                            <p class="error special">@lang('1 special character minimum')</p>
                                            <p class="error minimum">@lang('6 character password')</p>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6 mb15">
                                    <label class="form-label" for="password_confirm">@lang('Confirm Password')</label>
                                    <input type="password" id="password_confirm" name="password_confirmation"
                                        class="form-control form--control" required>
                                </div>
                                
                                <x-captcha></x-captcha>

                                @if ($general->agree)
                                    <div class="form-group custom--checkbox">
                                        <input type="checkbox" id="agree" @checked(old('agree'))
                                            name="agree" required>
                                        <label for="agree" class="ms-2">@lang('I agree with')
                                            @foreach ($policyPages as $policy)
                                                <a href="{{ route('policy.pages', [slug($policy->data_values->title), $policy->id]) }}"
                                                    class="text--base">
                                                    {{ __(@$policy->data_values->title) }}</a>
                                                @if (!$loop->last)
                                                    ,
                                                @endif
                                            @endforeach
                                        </label>
                                    </div>
                                @endif
                                <div class="d-grid mb20">
                                    <button class="ud-btn btn-thm default-box-shadow2" type="submit">Creat Account <i
                                            class="fal fa-arrow-right-long"></i></button>
                                </div>
                            </div>
                        </form>
                        <div class="hr_content mb20">
                            <hr><span class="hr_top_text">OR</span>
                        </div>
                        <div class="d-md-flex justify-content-between">
                            <button class="ud-btn btn-fb fz14 fw400 mb-2 mb-md-0" type="button"><i
                                    class="fab fa-facebook-f pr10"></i> Continue Facebook</button>
                            <button class="ud-btn btn-google fz14 fw400 mb-2 mb-md-0" type="button"><i
                                    class="fab fa-google"></i> Continue Google</button>
                            <button class="ud-btn btn-apple fz14 fw400" type="button"><i class="fab fa-apple"></i> Continue
                                Apple</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center">@lang('You already have an account please Login')</h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm"
                        data-bs-dismiss="modal">@lang('Close')</button>
                    <a href="{{ route('user.login') }}" class="btn btn--base btn--sm">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script-lib')
    <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
@endpush
@push('script')
    <script>
        "use strict";
        (function($) {
            @if ($mobile_code)
                $(`option[data-code={{ $mobile_code }}]`).attr('selected', '');
            @endif

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            @if ($general->secure_password)
                $('input[name=password]').on('input', function() {
                    secure_password($(this));
                });

                $('[name=password]').focus(function() {
                    $(this).closest('.form-group').addClass('hover-input-popup');
                });

                $('[name=password]').focusout(function() {
                    $(this).closest('.form-group').removeClass('hover-input-popup');
                });
            @endif


            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });

            $('.actionBtn').on('click', function() {
                let action;
                let loginUrl;
                let pageTitle;

                if ($(this).data('type') == 'client') {
                    action = `{{ route('user.register') }}`;
                    loginUrl = `{{ route('user.login') }}`;
                    pageTitle = `{{ __(@$register->data_values->title) }}`;
                } else {
                    action = `{{ route('influencer.register') }}`;
                    loginUrl = `{{ route('influencer.login') }}`;
                    pageTitle = `{{ __(@$registerInfluencer->data_values->title) }}`;
                }
                $('form')[0].action = action;

                $(this).addClass('active');
                $('.login-url').attr('href', loginUrl);
                $('.this-page-title').text(pageTitle);
                $('.actionBtn').not($(this)).removeClass('active');
            });

        })(jQuery);
    </script>
@endpush
