@php
    $login = getContent('user_login.content', true);
    $influencerLogin = getContent('influencer_login.content', true);
@endphp

@extends($activeTemplate . 'layouts.frontend2')
@section('content')
    <section class="our-login">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 m-auto wow fadeInUp" data-wow-delay="300ms">
                    <div class="main-title text-center">
                        <h2 class="title">Login</h2>
                        {{-- <p class="paragraph">Give your visitor a smooth online experience with a solid UX design</p> --}}
                    </div>
                </div>
            </div>
            <div class="row wow fadeInRight" data-wow-delay="300ms">
                <div class="col-xl-6 mx-auto">
                    <div class="log-reg-form search-modal form-style1 bgc-white p50 p30-sm default-box-shadow1 bdrs12">
                        <div class="mb30">
                            <h4>We're glad to see you again!</h4>
                            <p class="text">Don't have an account? <a href="{{ route('user.register') }}"
                                    class="text-thm">Sign Up!</a></p>
                        </div>
                        <form method="POST" action="{{ route('user.login') }}" class="verify-gcaptcha">
                            @csrf
                            <div class="mb20">
                                <label class="form-label fw600 dark-color">Email Address</label>
                                <input type="email" autocomplete  name="username" class="form-control" placeholder="example@gmail.com">
                            </div>
                            <div class="mb15">
                                <label class="form-label fw600 dark-color">Password</label>
                                <input type="text" autocomplete name="password" class="form-control" placeholder="*******">
                            </div>
                            <div class="checkbox-style1 d-block d-sm-flex align-items-center justify-content-between mb20">
                                <label class="custom_checkbox fz14 ff-heading">@lang('Remember Me')
                                    <input type="checkbox"  name="remember" id="remember">
                                    <span class="checkmark"></span>
                                </label>
                                <x-captcha></x-captcha>

                                <div class="d-flex justify-content-between flex-wrap">
                                   
                                    <a class="text--base forgot-url" href="{{ route('user.password.request') }}">@lang('Forgot Password?')</a>
                                </div>
                            </div>
                            <div class="d-grid mb20">
                                <button class="ud-btn btn-thm" type="submit">Log In <i
                                        class="fal fa-arrow-right-long"></i></button>
                            </div>
                        </form>
                        <div class="hr_content mb20">
                            <hr><span class="hr_top_text">OR</span>
                        </div>
                        <div class="d-md-flex justify-content-between">
                            <button class="ud-btn btn-fb fz14 fw400 mb-2 mb-md-0" type="button"><i
                                    class="fab fa-facebook-f pr10"></i> Continue Facebook</button>
                            <button class="ud-btn btn-google fz14 fw400 mb-2 mb-md-0" type="button"><i
                                    class="fab fa-google"></i> Continue Google</button>
                            <button class="ud-btn btn-apple fz14 fw400" type="button"><i class="fab fa-apple"></i> Continue
                                Apple</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.actionBtn').on('click', function() {
                let action;
                let forgotUrl;
                let registerUrl;
                let pageTitle;

                if ($(this).data('type') == 'client') {
                    action = `{{ route('user.login') }}`;
                    forgotUrl = `{{ route('user.password.request') }}`;
                    registerUrl = `{{ route('user.register') }}`;
                    pageTitle = `{{ __(@$login->data_values->title) }}`;
                } else {
                    action = `{{ route('influencer.login') }}`;
                    forgotUrl = `{{ route('influencer.password.request') }}`;
                    registerUrl = `{{ route('influencer.register') }}`;
                    pageTitle = `{{ __(@$influencerLogin->data_values->title) }}`;
                }

                $('form')[0].action = action;
                $('.forgot-url').attr('href', forgotUrl);
                $('.register-url').attr('href', registerUrl);
                $('.this-page-title').text(pageTitle);
                $(this).addClass('active');
                $('.actionBtn').not($(this)).removeClass('active');
            });

        })(jQuery);
    </script>
@endpush
