<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords"
        content="bidding, fiverr, freelance marketplace, freelancers, freelancing, gigs, hiring, job board, job portal, job posting, jobs marketplace, peopleperhour, proposals, sell services, upwork">
    <meta name="description" content="Freeio - Freelance Marketplace HTML Template">
    <meta name="CreativeLayers" content="ATFN">
    <!-- css file -->
    <link rel="stylesheet" href="theme/css/bootstrap.min.css">
    <link rel="stylesheet" href="theme/css/ace-responsive-menu.css">
    <link rel="stylesheet" href="theme/css/menu.css">
    <link rel="stylesheet" href="theme/css/fontawesome.css">
    <link rel="stylesheet" href="theme/css/flaticon.css">
    <link rel="stylesheet" href="theme/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="theme/css/ud-custom-spacing.css">
    <link rel="stylesheet" href="theme/css/animate.css">
    <link rel="stylesheet" href="theme/css/magnific-popup.css">
    <link rel="stylesheet" href="theme/css/slider.css">
    <link rel="stylesheet" href="theme/css/jquery-ui.min.css">
    <link rel="stylesheet" href="theme/css/style.css">
    <!-- Responsive stylesheet -->
    <link rel="stylesheet" href="theme/css/responsive.css">
    <!-- Title -->
    <title>Freeio - Freelance Marketplace HTML Template</title>
    <!-- Favicon -->
    <link href="theme/images/favicon.ico" sizes="128x128" rel="shortcut icon" type="image/x-icon" />
    <link href="theme/images/favicon.ico" sizes="128x128" rel="shortcut icon" />
    <!-- Apple Touch Icon -->
    <link href="theme/images/apple-touch-icon-60x60.png" sizes="60x60" rel="apple-touch-icon">
    <link href="theme/images/apple-touch-icon-72x72.png" sizes="72x72" rel="apple-touch-icon">
    <link href="theme/images/apple-touch-icon-114x114.png" sizes="114x114" rel="apple-touch-icon">
    <link href="theme/images/apple-touch-icon-180x180.png" sizes="180x180" rel="apple-touch-icon">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

</head>
@extends($activeTemplate . 'layouts.frontend2')
@section('content')

    <body>
        <div class="wrapper ovh" style="margin-top: 100px;">
            <div class="preloader"></div>

            <!-- Filter Content In Hiddn SideBar -->
            <div class="lefttside-hidden-bar">
                <div class="hsidebar-header bdrb1">
                    <h4 class="list-title">All filters</h4>
                    <div class="sidebar-close-icon"><span class="far fa-times"></span></div>
                </div>
                <div class="hsidebar-content">
                    <div class="widget-wrapper">
                        <div class="sidebar-accordion">
                            <div class="accordion" id="accordionExample2">
                                <div class="card mb20 pb10">
                                    <div class="card-header active" id="headingZero">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseZero" aria-expanded="true"
                                                aria-controls="collapseZero">Delivery Time</button>
                                        </h4>
                                    </div>
                                    <div id="collapseZero" class="collapse show" aria-labelledby="headingZero"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <div class="radio-element">
                                                <div class="form-check d-flex align-items-center mb10">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault"
                                                        id="flexRadioDefault1s">
                                                    <label class="form-check-label" for="flexRadioDefault1s">Express
                                                        24H</label><span class="right-tags">(1,945)</span>
                                                </div>
                                                <div class="form-check d-flex align-items-center mb10">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault"
                                                        id="flexRadioDefault2s" checked="checked">
                                                    <label class="form-check-label" for="flexRadioDefault2s">Up to 3
                                                        days</label><span class="right-tags">(8,136)</span>
                                                </div>
                                                <div class="form-check d-flex align-items-center mb10">
                                                    <input class="form-check-input" type="radio"
                                                        name="flexRadioDefault" id="flexRadioDefault3s">
                                                    <label class="form-check-label" for="flexRadioDefault3s">Up to 7
                                                        days</label><span class="right-tags">(917)</span>
                                                </div>
                                                <div class="form-check d-flex align-items-center">
                                                    <input class="form-check-input" type="radio"
                                                        name="flexRadioDefault" id="flexRadioDefault4s">
                                                    <label class="form-check-label"
                                                        for="flexRadioDefault4s">Anytime</label><span
                                                        class="right-tags">(240)</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb20 pb0">
                                    <div class="card-header" id="headingOnes">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOnes" aria-expanded="true"
                                                aria-controls="collapseOnes">Budget</button>
                                        </h4>
                                    </div>
                                    <div id="collapseOnes" class="collapse" aria-labelledby="headingOnes"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <!-- Range Slider Mobile Version -->
                                            <div class="range-slider-style2">
                                                <div class="range-wrapper">
                                                    <div class="mb10 mt15" id="slider"></div>
                                                    <div class="d-flex align-items-center justify-content-center">
                                                        <span id="slider-range-value1"></span><i
                                                            class="fa-sharp fa-solid fa-minus mx-2 dark-color icon"></i>
                                                        <span id="slider-range-value2"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb20 pb5">
                                    <div class="card-header" id="headingTwos">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwos" aria-expanded="true"
                                                aria-controls="collapseTwos">Design Tool</button>
                                        </h4>
                                    </div>
                                    <div id="collapseTwos" class="collapse" aria-labelledby="headingTwos"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <div class="checkbox-style1 mb15">
                                                <label class="custom_checkbox">Adobe Photoshop
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(1,945)</span>
                                                </label>
                                                <label class="custom_checkbox">Figma
                                                    <input type="checkbox" checked="checked">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(8,136)</span>
                                                </label>
                                                <label class="custom_checkbox">Sketch
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(917)</span>
                                                </label>
                                                <label class="custom_checkbox">Adobe XD
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(240)</span>
                                                </label>
                                                <label class="custom_checkbox">Balsamiq
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">((2,460)</span>
                                                </label>
                                            </div>
                                            <a class="text-thm" href="">+20 more</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb20 pb5">
                                    <div class="card-header" id="headingThrees">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThrees" aria-expanded="true"
                                                aria-controls="collapseThrees">Location</button>
                                        </h4>
                                    </div>
                                    <div id="collapseThrees" class="collapse" aria-labelledby="headingThrees"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <div class="search_area mb15">
                                                <input type="text" class="form-control"
                                                    placeholder="What are you looking for?">
                                                <label><span class="flaticon-loupe"></span></label>
                                            </div>
                                            <div class="checkbox-style1 mb15">
                                                <label class="custom_checkbox">United States
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(1,945)</span>
                                                </label>
                                                <label class="custom_checkbox">United Kingdom
                                                    <input type="checkbox" checked="checked">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(8,136)</span>
                                                </label>
                                                <label class="custom_checkbox">Canada
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(917)</span>
                                                </label>
                                                <label class="custom_checkbox">Germany
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(240)</span>
                                                </label>
                                                <label class="custom_checkbox">Turkey
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">((2,460)</span>
                                                </label>
                                            </div>
                                            <a class="text-thm" href="">+20 more</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb20 pb5">
                                    <div class="card-header" id="headingFours">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseFours" aria-expanded="true"
                                                aria-controls="collapseFours">Speaks</button>
                                        </h4>
                                    </div>
                                    <div id="collapseFours" class="collapse" aria-labelledby="headingFours"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <div class="checkbox-style1 mb15">
                                                <label class="custom_checkbox">Turkish
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(1,945)</span>
                                                </label>
                                                <label class="custom_checkbox">English
                                                    <input type="checkbox" checked="checked">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(8,136)</span>
                                                </label>
                                                <label class="custom_checkbox">Italian
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(917)</span>
                                                </label>
                                                <label class="custom_checkbox">Spanish
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(240)</span>
                                                </label>
                                            </div>
                                            <a class="text-thm" href="">+20 more</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb20 pb0">
                                    <div class="card-header" id="headingFives">
                                        <h4>
                                            <button class="btn btn-link ps-0" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseFives" aria-expanded="true"
                                                aria-controls="collapseFives">Level</button>
                                        </h4>
                                    </div>
                                    <div id="collapseFives" class="collapse" aria-labelledby="headingFives"
                                        data-parent="#accordionExample">
                                        <div class="card-body card-body px-0 pt-0">
                                            <div class="checkbox-style1">
                                                <label class="custom_checkbox">Top Rated Seller
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(1,945)</span>
                                                </label>
                                                <label class="custom_checkbox">Level Two
                                                    <input type="checkbox" checked="checked">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(8,136)</span>
                                                </label>
                                                <label class="custom_checkbox">Level One
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(917)</span>
                                                </label>
                                                <label class="custom_checkbox">New Seller
                                                    <input type="checkbox">
                                                    <span class="checkmark"></span>
                                                    <span class="right-tags">(240)</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Filter Content In Hiddn SideBar -->
            <div class="hiddenbar-body-ovelay"></div>

            <!-- Mobile Nav  -->
            <div id="page" class="mobilie_header_nav stylehome1">
                <div class="mobile-menu">
                    <div class="header bdrb1">
                        <div class="menu_and_widgets">
                            <div class="mobile_menu_bar d-flex justify-content-between align-items-center">
                                <a class="mobile_logo" href="#"><img src="theme/images/header-logo-dark.svg"
                                        alt=""></a>
                                <div class="right-side text-end">
                                    <a class="" href="page-login.html">join</a>
                                    <a class="menubar ml30" href="#menu"><img
                                            src="theme/images/mobile-dark-nav-icon.svg" alt=""></a>
                                </div>
                            </div>
                        </div>
                        <div class="posr">
                            <div class="mobile_menu_close_btn"><span class="far fa-times"></span></div>
                        </div>
                    </div>
                </div>
                <!-- /.mobile-menu -->
                <nav id="menu" class="">
                    <ul>
                        <li><span>Home</span>
                            <ul>
                                <li><a href="index.html">Home V1</a></li>
                                <li><a href="index2.html">Home V2</a></li>
                                <li><a href="index3.html">Home V3</a></li>
                                <li><a href="index4.html">Home V4</a></li>
                                <li><a href="index5.html">Home V5</a></li>
                                <li><a href="index6.html">Home V6</a></li>
                                <li><a href="index7.html">Home V7</a></li>
                                <li><a href="index8.html">Home V8</a></li>
                                <li><a href="index9.html">Home V9</a></li>
                                <li><a href="index10.html">Home V10</a></li>
                            </ul>
                        </li>
                        <li><span>Browse Jobs</span>
                            <ul>
                                <li><span>Services</span>
                                    <ul>
                                        <li><a href="page-service-v1.html">Service v1</a></li>
                                        <li><a href="page-service-v2.html">Service v2</a></li>
                                        <li><a href="page-service-v3.html">Service v3</a></li>
                                        <li><a href="page-service-v4.html">Service v4</a></li>
                                        <li><a href="page-service-v5.html">Service v5</a></li>
                                        <li><a href="page-service-v6.html">Service v6</a></li>
                                        <li><a href="page-service-v7.html">Service v7</a></li>
                                        <li><a href="page-service-all.html">Service All</a></li>
                                        <li><a href="page-service-single.html">Service Single</a></li>
                                    </ul>
                                </li>
                                <li><span>Projects</span>
                                    <ul>
                                        <li><a href="page-project-v1.html">Project v1</a></li>
                                        <li><a href="page-project-single.html">Project Single</a></li>
                                    </ul>
                                </li>
                                <li><span>Job View</span>
                                    <ul>
                                        <li><a href="page-job-list-v1.html">Job list v1</a></li>
                                        <li><a href="page-job-list-v2.html">Job list v2</a></li>
                                        <li><a href="page-job-list-v3.html">Job list V3</a></li>
                                        <li><a href="page-job-list-single.html">Job Single</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li><span>Users</span>
                            <ul>
                                <li><span>Dashboard</span>
                                    <ul>
                                        <li><a href="page-dashboard.html">Dashboard</a></li>
                                        <li><a href="page-dashboard-proposal.html">Proposal</a></li>
                                        <li><a href="page-dashboard-save.html">Saved</a></li>
                                        <li><a href="page-dashboard-message.html">Message</a></li>
                                        <li><a href="page-dashboard-reviews.html">Reviews</a></li>
                                        <li><a href="page-dashboard-invoice.html">Invoice</a></li>
                                        <li><a href="page-dashboard-payouts.html">Payouts</a></li>
                                        <li><a href="page-dashboard-statement.html">Statement</a></li>
                                        <li><a href="page-dashboard-manage-service.html">Manage Service</a></li>
                                        <li><a href="page-dashboard-add-service.html">Add Services</a></li>
                                        <li><a href="page-dashboard-manage-jobs.html">Manage Jobs</a></li>
                                        <li><a href="page-dashboard-manage-project.html">Manage Project</a></li>
                                        <li><a href="page-dashboard-create-project.html">Create Project</a></li>
                                        <li><a href="page-dashboard-profile.html">My Profile</a></li>
                                    </ul>
                                </li>
                                <li><span>Employee</span>
                                    <ul>
                                        <li><a href="page-employee-v1.html">Employee V1</a></li>
                                        <li><a href="page-employee-v2.html">Employee V2</a></li>
                                        <li><a href="page-employee-single.html">Employee Single</a></li>
                                    </ul>
                                </li>
                                <li><span>Freelancer</span>
                                    <ul>
                                        <li><a href="page-freelancer-v1.html">Freelancer V1</a></li>
                                        <li><a href="page-freelancer-v2.html">Freelancer V2</a></li>
                                        <li><a href="page-freelancer-v3.html">Freelancer V3</a></li>
                                        <li><a href="page-freelancer-single.html">Freelancer Single</a></li>
                                    </ul>
                                </li>
                                <li><a href="page-become-seller.html">Become Seller</a></li>
                            </ul>
                        </li>
                        <li><span>Pages</span>
                            <ul>
                                <li><span>About</span>
                                    <ul>
                                        <li><a href="page-about.html">About v1</a></li>
                                        <li><a href="page-about-v2.html">About v2</a></li>
                                    </ul>
                                </li>
                                <li><span>Shop</span>
                                    <ul>
                                        <li><a href="page-shop.html">List</a></li>
                                        <li><a href="page-shop-single.html">Single</a></li>
                                        <li><a href="page-shop-cart.html">Cart</a></li>
                                        <li><a href="page-shop-checkout.html">Checkout</a></li>
                                        <li><a href="page-shop-order.html">Order</a></li>
                                    </ul>
                                </li>
                                <li><a href="page-contact.html">Contact</a></li>
                                <li><a href="page-error.html">404</a></li>
                                <li><a href="page-faq.html">Faq</a></li>
                                <li><a href="page-help.html">Help</a></li>
                                <li><a href="page-invoice.html">Invoices</a></li>
                                <li><a href="page-login.html">Login</a></li>
                                <li><a href="page-pricing.html">Pricing</a></li>
                                <li><a href="page-register.html">Register</a></li>
                                <li><a href="page-terms.html">Terms</a></li>
                                <li><a href="page-ui-element.html">UI Elements</a></li>
                            </ul>
                        </li>
                        <li><span>Blog</span>
                            <ul>
                                <li><a href="page-blog-v1.html">List V1</a></li>
                                <li><a href="page-blog-v2.html">List V2</a></li>
                                <li><a href="page-blog-v3.html">List V3</a></li>
                                <li><a href="page-blog-single.html">Single</a></li>
                            </ul>
                        </li>
                        <!-- Only for Mobile View -->
                    </ul>
                </nav>
            </div>


            <!-- Listings All Lists -->
            <section class="pt30 pb90">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="list-sidebar-style1 d-none d-lg-block">
                                <div class="accordion" id="accordionExample">
                                    <div class="card mb20 pb10 mt-0">
                                        <div class="card-header active" id="heading0">
                                            <h4>
                                                <button class="btn btn-link ps-0 pt-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse0"
                                                    aria-expanded="true" aria-controls="collapse0">Delivery
                                                    Time</button>
                                            </h4>
                                        </div>
                                        <div id="collapse0" class="collapse show" aria-labelledby="heading0"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <div class="radio-element">
                                                    <div class="form-check d-flex align-items-center mb10">
                                                        <input class="form-check-input" type="radio"
                                                            name="flexRadioDefault" id="flexRadioDefault1a">
                                                        <label class="form-check-label" for="flexRadioDefault1a">Express
                                                            24H</label><span class="right-tags">(1,945)</span>
                                                    </div>
                                                    <div class="form-check d-flex align-items-center mb10">
                                                        <input class="form-check-input" type="radio"
                                                            name="flexRadioDefault" id="flexRadioDefault2a"
                                                            checked="checked">
                                                        <label class="form-check-label" for="flexRadioDefault2a">Up
                                                            to 3 days</label><span class="right-tags">(8,136)</span>
                                                    </div>
                                                    <div class="form-check d-flex align-items-center mb10">
                                                        <input class="form-check-input" type="radio"
                                                            name="flexRadioDefault" id="flexRadioDefault3a">
                                                        <label class="form-check-label" for="flexRadioDefault3a">Up
                                                            to 7 days</label><span class="right-tags">(917)</span>
                                                    </div>
                                                    <div class="form-check d-flex align-items-center">
                                                        <input class="form-check-input" type="radio"
                                                            name="flexRadioDefault" id="flexRadioDefault4a">
                                                        <label class="form-check-label"
                                                            for="flexRadioDefault4a">Anytime</label><span
                                                            class="right-tags">(240)</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card mb20 pb0">
                                        <div class="card-header active" id="heading1">
                                            <h4>
                                                <button class="btn btn-link ps-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse1"
                                                    aria-expanded="true" aria-controls="collapse1">Budget</button>
                                            </h4>
                                        </div>
                                        <div id="collapse1" class="collapse show" aria-labelledby="heading1"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <!-- Range Slider Desktop Version -->
                                                <div class="range-slider-style1">
                                                    <div class="range-wrapper">
                                                        <div class="slider-range mb10 mt15"></div>
                                                        <div class="text-center">
                                                            <input type="text" class="amount" placeholder="$20"><span
                                                                class="fa-sharp fa-solid fa-minus mx-2 dark-color"></span>
                                                            <input type="text" class="amount2" placeholder="$70987">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card mb20 pb5">
                                        <div class="card-header active" id="heading2">
                                            <h4>
                                                <button class="btn btn-link ps-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse2"
                                                    aria-expanded="true" aria-controls="collapse2">Design
                                                    Tool</button>
                                            </h4>
                                        </div>
                                        <div id="collapse2" class="collapse show" aria-labelledby="heading2"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <div class="checkbox-style1 mb15">
                                                    <label class="custom_checkbox">Adobe Photoshop
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(1,945)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Figma
                                                        <input type="checkbox" checked="checked">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(8,136)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Sketch
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(917)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Adobe XD
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(240)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Balsamiq
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">((2,460)</span>
                                                    </label>
                                                </div>
                                                <a class="text-thm" href="">+20 more</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card mb20 pb5">
                                        <div class="card-header active" id="heading3">
                                            <h4>
                                                <button class="btn btn-link ps-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse3"
                                                    aria-expanded="true" aria-controls="collapse3">Location</button>
                                            </h4>
                                        </div>
                                        <div id="collapse3" class="collapse show" aria-labelledby="heading3"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <div class="search_area mb15">
                                                    <input type="text" class="form-control"
                                                        placeholder="What are you looking for?">
                                                    <label><span class="flaticon-loupe"></span></label>
                                                </div>
                                                <div class="checkbox-style1 mb15">
                                                    <label class="custom_checkbox">United States
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(1,945)</span>
                                                    </label>
                                                    <label class="custom_checkbox">United Kingdom
                                                        <input type="checkbox" checked="checked">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(8,136)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Canada
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(917)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Germany
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(240)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Turkey
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(2,460)</span>
                                                    </label>
                                                </div>
                                                <a class="text-thm" href="">+20 more</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card mb20 pb5">
                                        <div class="card-header active" id="heading4">
                                            <h4>
                                                <button class="btn btn-link ps-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse4"
                                                    aria-expanded="true" aria-controls="collapse4">Speaks</button>
                                            </h4>
                                        </div>
                                        <div id="collapse4" class="collapse show" aria-labelledby="heading4"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <div class="checkbox-style1 mb15">
                                                    <label class="custom_checkbox">Turkish
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(1,945)</span>
                                                    </label>
                                                    <label class="custom_checkbox">English
                                                        <input type="checkbox" checked="checked">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(8,136)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Italian
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(917)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Spanish
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(240)</span>
                                                    </label>
                                                </div>
                                                <a class="text-thm" href="">+20 more</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card mb20 pb0">
                                        <div class="card-header active" id="heading5">
                                            <h4>
                                                <button class="btn btn-link ps-0" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse5"
                                                    aria-expanded="true" aria-controls="collapse5">Level</button>
                                            </h4>
                                        </div>
                                        <div id="collapse5" class="collapse show" aria-labelledby="heading5"
                                            data-parent="#accordionExample">
                                            <div class="card-body card-body px-0 pt-0">
                                                <div class="checkbox-style1">
                                                    <label class="custom_checkbox">Top Rated Seller
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(1,945)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Level Two
                                                        <input type="checkbox" checked="checked">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(8,136)</span>
                                                    </label>
                                                    <label class="custom_checkbox">Level One
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(917)</span>
                                                    </label>
                                                    <label class="custom_checkbox">New Seller
                                                        <input type="checkbox">
                                                        <span class="checkmark"></span>
                                                        <span class="right-tags">(240)</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <div class="row align-items-center mb20">
                                <div class="col-md-6">
                                    <div class="text-center text-md-start">
                                        <p class="text mb-0 mb10-sm"><span class="fw500">5,512</span> services
                                            available</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div
                                        class="page_control_shorting d-md-flex align-items-center justify-content-center justify-content-md-end">
                                        <div class="dropdown-lists d-block d-lg-none me-2 mb10-sm">
                                            <ul class="p-0 mb-0 text-center text-md-start">
                                                <li>
                                                    <!-- Advance Features modal trigger -->
                                                    <button type="button" class="open-btn filter-btn-left"> <img
                                                            class="me-2" src="theme/images/icon/all-filter-icon.svg"
                                                            alt=""> All Filter</button>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="pcs_dropdown dark-color pr10 text-center text-md-end"><span>Sort
                                                by</span>
                                            <select class="selectpicker show-tick">
                                                <option>Best Selling</option>
                                                <option>Recommended</option>
                                                <option>New Arrivals</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @php
                                    $servicePropular = getContent('service.content', true);
                                    $servicesPropular = App\Models\Service::approved()
                                        ->with('influencer', 'category')
                                        ->latest()
                                        ->orderBy('rating', 'desc')
                                        ->take(20)
                                        ->get();
                                @endphp
                                @if ($servicesPropular->count() > 0)
                                    @foreach ($servicesPropular as $service)
                                        <div class="col-sm-6 col-xl-4">
                                            <div class="listing-style1">
                                                <div class="list-thumb">
                                                    <div
                                                        class="listing-thumbIn-slider position-relative navi_pagi_bottom_center slider-1-grid owl-carousel owl-theme">

                                                        <div class="item">
                                                            <img class="w-100"
                                                                src="{{ getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service')) }}"
                                                                alt="images">
                                                            <a href="" class="listing-fav fz12"><span
                                                                    class="far fa-heart"></span></a>
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="list-content">
                                                    <p class="list-text body-color fz14 mb-1">
                                                        {{ __(@$service->category->name) }}</p>
                                                    <h5 class="list-title"><a
                                                            href="{{ route('service.details', [slug($service->title), $service->id]) }}">{{ __(@$service->title) }}</a>
                                                    </h5>
                                                    <div class="review-meta d-flex align-items-center">
                                                        <i class="fas fa-star fz10 review-color me-2"></i>
                                                        <p class="mb-0 body-color fz14">
                                                            <span
                                                                class="dark-color me-2">{{ $service->rating }}</span>{{ $service->reviews_count ?? 0 }}
                                                            reviews
                                                        </p>
                                                    </div>
                                                    <hr class="my-2">
                                                    <div
                                                        class="list-meta d-flex justify-content-between align-items-center mt15">
                                                        <a href="">
                                                            <span class="position-relative mr10">
                                                                <img class="rounded-circle"
                                                                    src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                                                    alt="Freelancer Photo"
                                                                    style="width: 40px; height: 40px;">
                                                                <span class="online-badge"></span>
                                                            </span>
                                                            <span
                                                                class="fz14">{{ __(@$service->influencer->username) }}</span>
                                                        </a>
                                                        <div class="budget">
                                                            <p class="mb-0 body-color">Starting at<span
                                                                    class="fz17 fw500 dark-color ms-1">{{ showAmount($service->price) }}</span>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="row">
                                <div class="mbp_pagination mt30 text-center">
                                    <ul class="page_navigation">
                                        <li class="page-item">
                                            <a class="page-link" href="#"> <span
                                                    class="fas fa-angle-left"></span></a>
                                        </li>
                                        <li class="page-item"><a class="page-link" href="#">1</a></li>
                                        <li class="page-item active" aria-current="page">
                                            <a class="page-link" href="#">2 <span
                                                    class="sr-only">(current)</span></a>
                                        </li>
                                        <li class="page-item"><a class="page-link" href="#">3</a></li>
                                        <li class="page-item"><a class="page-link" href="#">4</a></li>
                                        <li class="page-item d-inline-block d-sm-none"><a class="page-link"
                                                href="#">...</a></li>
                                        <li class="page-item"><a class="page-link" href="#">5</a></li>
                                        <li class="page-item d-none d-sm-inline-block"><a class="page-link"
                                                href="#">...</a></li>
                                        <li class="page-item d-none d-sm-inline-block"><a class="page-link"
                                                href="#">20</a></li>
                                        <li class="page-item">
                                            <a class="page-link" href="#"><span
                                                    class="fas fa-angle-right"></span></a>
                                        </li>
                                    </ul>
                                    {{-- <p class="mt10 mb-0 pagination_page_count text-center">1 – 20 of 300+ property
                                        available</p> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Our Footer -->
            {{-- <section class="footer-style1 pt25 pb-0">
                <div class="container">
                    <div class="row bb-white-light pb10 mb60">
                        <div class="col-md-7">
                            <div
                                class="d-block text-center text-md-start justify-content-center justify-content-md-start d-md-flex align-items-center mb-3 mb-md-0">
                                <a class="fz17 fw500 text-white mr15-md mr30" href="">Terms of Service</a>
                                <a class="fz17 fw500 text-white mr15-md mr30" href="">Privacy Policy</a>
                                <a class="fz17 fw500 text-white" href="">Site Map</a>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="social-widget text-center text-md-end">
                                <div class="social-style1">
                                    <a class="text-white me-2 fw500 fz17" href="">Follow us</a>
                                    <a href=""><i class="fab fa-facebook-f list-inline-item"></i></a>
                                    <a href=""><i class="fab fa-twitter list-inline-item"></i></a>
                                    <a href=""><i class="fab fa-instagram list-inline-item"></i></a>
                                    <a href=""><i class="fab fa-linkedin-in list-inline-item"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-lg-3">
                            <div class="link-style1 mb-4 mb-sm-5">
                                <h5 class="text-white mb15">About</h5>
                                <div class="link-list">
                                    <a href="">Careers</a>
                                    <a href="">Press & News</a>
                                    <a href="">Partnerships</a>
                                    <a href="">Privacy Policy</a>
                                    <a href="">Terms of Service</a>
                                    <a href="">Investor Relations</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="link-style1 mb-4 mb-sm-5">
                                <h5 class="text-white mb15">Categories</h5>
                                <ul class="ps-0">
                                    <li><a href="">Graphics & Design</a></li>
                                    <li><a href="">Digital Marketing</a></li>
                                    <li><a href="">Writing & Translation</a></li>
                                    <li><a href="">Video & Animation</a></li>
                                    <li><a href="">Music & Audio</a></li>
                                    <li><a href="">Programming & Tech</a></li>
                                    <li><a href="">Data</a></li>
                                    <li><a href="">Business</a></li>
                                    <li><a href="">Lifestyle</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="link-style1 mb-4 mb-sm-5">
                                <h5 class="text-white mb15">Support</h5>
                                <ul class="ps-0">
                                    <li><a href="">Help & Support</a></li>
                                    <li><a href="">Trust & Safety</a></li>
                                    <li><a href="">Selling on Freeio</a></li>
                                    <li><a href="">Buying on Freeio</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="footer-widget">
                                <div class="footer-widget mb-4 mb-sm-5">
                                    <div class="mailchimp-widget">
                                        <h5 class="title text-white mb20">Subscribe</h5>
                                        <div class="mailchimp-style1">
                                            <input type="email" class="form-control"
                                                placeholder="Your email address">
                                            <button type="submit">Send</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="app-widget mb-4 mb-sm-5">
                                    <h5 class="title text-white mb20">Apps</h5>
                                    <div class="row mb-4 mb-lg-5">
                                        <div class="col-lg-12">
                                            <a class="app-list d-flex align-items-center mb10" href="">
                                                <i class="fab fa-apple fz17 mr15"></i>
                                                <h6 class="app-title fz15 fw400 mb-0">iOS App</h6>
                                            </a>
                                            <a class="app-list d-flex align-items-center" href="">
                                                <i class="fab fa-google-play fz15 mr15"></i>
                                                <h6 class="app-title fz15 fw400 mb-0">Android App</h6>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container white-bdrt1 py-4">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="text-center text-lg-start">
                                <p class="copyright-text mb-2 mb-md-0 text-white-light ff-heading">© Freeio. 2023
                                    CreativeLayers. All rights reserved.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="footer_bottom_right_btns text-center text-lg-end">
                                <ul class="p-0 m-0">
                                    <li class="list-inline-item">
                                        <select class="selectpicker show-tick">
                                            <option>US$ USD</option>
                                            <option>Euro</option>
                                            <option>Pound</option>
                                        </select>
                                    </li>
                                    <li class="list-inline-item">
                                        <select class="selectpicker show-tick">
                                            <option>English</option>
                                            <option>Frenc</option>
                                            <option>Italian</option>
                                            <option>Spanish</option>
                                            <option>Turkey</option>
                                        </select>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section> --}}
            <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
        </div>
        </div>
        <!-- Wrapper End -->
        <script src="theme/js/jquery-3.6.4.min.js"></script>
        <script src="theme/js/jquery-migrate-3.0.0.min.js"></script>
        <script src="theme/js/popper.min.js"></script>
        <script src="theme/js/bootstrap.min.js"></script>
        <script src="theme/js/bootstrap-select.min.js"></script>
        <script src="theme/js/jquery.mmenu.all.js"></script>
        <script src="theme/js/ace-responsive-menu.js"></script>
        <script src="theme/js/jquery-scrolltofixed-min.js"></script>
        <script src="theme/js/wow.min.js"></script>
        <script src="theme/js/isotop.js"></script>
        <script src="theme/js/owl.js"></script>
        <script src="theme/js/pricing-slider.js"></script>
        <!-- Custom script for all pages -->
        <script src="theme/js/script.js"></script>
    </body>
@endsection

</html>
