@php
$emptyMsgImage = getContent('empty_message.content', true);
@endphp
@if(request()->search)
<p>@lang('Search Result For') <span class="text--base">{{ __(request()->search) }}</span> : @lang('Total') <span class="text--base">{{ $services->count() }}</span> @lang('Service Found')</p>
@endif
@forelse ($services as $service)
<div class="col-sm-6 col-xl-4">
    <div class="listing-style1">
        <div class="list-thumb">
            <a href="{{ route('service.details', [slug($service->title), $service->id]) }}">
                <img class="w-100"
                        src="{{ getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service')) }}"
                        alt="images">
            </a>
        </div>
        <div class="list-content">
            <p class="list-text body-color fz14 mb-1">
                {{ __(@$service->category->name) }}</p>
            <h5 class="list-title"><a
                    href="{{ route('service.details', [slug($service->title), $service->id]) }}">{{ __(@$service->title) }}</a>
            </h5>
            <div class="review-meta d-flex align-items-center">
                <i class="fas fa-star fz10 review-color me-2"></i>
                <p class="mb-0 body-color fz14">
                    <span
                        class="dark-color me-2">{{ $service->rating }}</span>{{ $service->reviews_count ?? 0 }}
                    reviews
                </p>
            </div>
            <hr class="my-2">
            <div
                class="list-meta d-flex justify-content-between align-items-center mt15">
                <a href="">
                    <span class="position-relative mr10">
                        <img class="rounded-circle"
                            src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                            alt="Freelancer Photo"
                            style="width: 40px; height: 40px;">
                        <span class="online-badge"></span>
                    </span>
                    <span
                        class="fz14">{{ __(@$service->influencer->username) }}</span>
                </a>
                <div class="budget">
                    <p class="mb-0 body-color">Starting at<span
                            class="fz17 fw500 dark-color ms-1">{{ showAmount($service->price) }}</span>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@empty
<div class="col-md-6 col-lg-8">
    <img src="{{ getImage('assets/images/frontend/empty_message/' . @$emptyMsgImage->data_values->image, '800x600') }}" alt="" class="w-100">
</div>
@endforelse
{{ $services->links() }}
