@extends($activeTemplate . 'layouts.frontend2')
@section('content')
    <style>
        .day-section {
            margin-bottom: 2rem;
        }

        .interval-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }

        .toggle-btn {
            padding: 6px 10px;
            font-size: 0.8rem;
        }

        .toggle-btn.active {
            background-color: #0d6efd;
            color: white;
        }

        .air-datepicker.-inline- {
            border-color: var(--adp-border-color-inline);
            box-shadow: none;
            position: static;
            left: auto;
            right: auto;
            opacity: 1;
            transform: none;
            width: 100%;
        }
        @media (min-width: 768px) {
            .breadcumb-section {
                
                margin-top: 150px;
            }
        }
    </style>

    <section class="breadcumb-section pt-0 ">
        <div style="background-image: none; background-color: #1F4B3F;"
            class="cta-service-single cta-banner mx-auto maxw1700 pt120 pt60-sm pb120 pb60-sm bdrs16 position-relative overflow-hidden d-flex align-items-center mx20-lg px30-lg">
            <img class="left-top-img wow zoomIn" src="https://infu.nibiru-it.ro/theme/images/vector-img/left-top.png"
                alt="">
            <img class="right-bottom-img wow zoomIn" src="https://infu.nibiru-it.ro/theme/images/vector-img/right-bottom.png"
                alt="">
            {{-- <img class="service-v1-vector bounce-y d-none d-xl-block"
                src="https://infu.nibiru-it.ro/theme/images/vector-img/vector-service-v1.png" alt=""> --}}
            <div class="container">
                <div class="row wow fadeInUp">
                    <div class="col-xl-7">
                        <div class="position-relative">
                            <h2 class="text-white">{{ __($service->title) }}</h2>
                            <div class="list-meta mt30">
                                <a class="list-inline-item mb5-sm" href="">
                                    <span class="position-relative mr10">
                                        <img class="rounded-circle"
                                            src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                            alt="Freelancer Photo" style="width: 80px; height: 80px;">
                                        <span class="online-badge"></span>
                                    </span>
                                    <span class="fz14 text-white">{{ __(@$service->influencer->fullname) }}</span>
                                </a>
                                <p class="mb-0  text-white dark-color fz14 list-inline-item ml25 ml15-sm mb5-sm ml0-xs"><i
                                        class="fas fa-star vam fz10 review-color me-2"></i>
                                    {{ @$service->influencer->rating }}
                                    ({{ getAmount(@$service->influencer->total_review) ?? 0 }})</p>
                                {{-- <p class="mb-0 dark-color fz14 list-inline-item ml25 ml15-sm mb5-sm ml0-xs"><i
                                            class="flaticon-file-1 vam fz20 me-2"></i> 2 Order in Queue</p> --}}
                                {{-- <p class="mb-0 dark-color fz14 list-inline-item ml25 ml15-sm mb5-sm ml0-xs"><i
                                            class="flaticon-website vam fz20 me-2"></i> 902 Views</p> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Service Details -->
    <section class="pt10 pb90 pb30-md">
        <div class="container">
            <div class="row wrap">
                <div class="col-lg-8">
                    <div class="column">
                        <div class="row">
                            <div class="col-12 col-md-3">
                                <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                    <div class="icon flex-shrink-0"><span class="flaticon-calendar"></span></div>
                                    <div class="details">
                                        <h5 class="title">Durată Sesiune</h5>
                                        <p class="mb-0 text">40 Min</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-md-3">
                                <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                    <div class="icon flex-shrink-0"><span class="flaticon-goal"></span></div>
                                    <div class="details">
                                        <h5 class="title">Skills</h5>
                                        <p class="mb-0 text">
                                            @if ($service->influencer->skills)
                                                @foreach ($service->influencer->skills as $skill)
                                                    <li>{{ __($skill) }}</li>
                                                @endforeach
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-md-3">
                                <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                    <div class="icon flex-shrink-0"><span class="flaticon-goal"></span></div>
                                    <div class="details">
                                        <h5 class="title">Categorie</h5>
                                        <p class="mb-0 text">
                                            {{ __($service->category->name) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                    <div class="icon flex-shrink-0"><span class="flaticon-tracking"></span></div>
                                    <div class="details">
                                        <h5 class="title">Oraș</h5>
                                        <p class="mb-0 text">{{ $service->influencer->address->city }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <img src="{{ getImage(getFilePath('service') . '/' . $service->image, getFileSize('service')) }}"
                            alt="" class="w-100" style="margin-bottom: 20px;margin-top: 20px;">
                        <div class="service-about">
                            <h4>Descriere</h4>
                            <p class="text mb30">{{ $service->description }}</p>



                            <div class="d-block d-md-none mb30" id="orderFormMobil">
                                <div class="price-widget">
                                    <div class="navtab-style1">
                                        <div class="row">
                                            <div class="col-6 d-flex justify-content-center align-items-center">
                                                <div class="price h-100">
                                                    {{ $general->cur_sym }}{{ showAmount($service->price) }}

                                                </div>
                                            </div>
                                            <div class="col-6 d-flex justify-content-center align-items-center">
                                                <ul class="p-0 mb15 d-sm-flex align-items-center h-100">
                                                    <li class="fz14 fw500 dark-color"><i
                                                            class="flaticon-sandclock fz20 text-thm2 me-2 vam"></i>40 Minute
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <form
                                            action="{{ route('user.order.confirm', [$service->influencer->id, $service->id]) }}"
                                            method="POST">
                                            @csrf



                                            <div id='calendar-mobil'>



                                            </div>

                                            <div id="available-times-mobil">

                                            </div>

                                            <textarea rows="6" class="form-control form--control mt-3" style="height:unset!important" name="description"
                                                id="description"
                                                placeholder="Scrie un mesaj pe care solver-ul sa il vada inainte de a accepta programarea ta......"></textarea>

                                            <input type="hidden" name="service_id" value="{{ $service->id }}">
                                            <input type="hidden" name="influencer_id"
                                                value="{{ $service->influencer->id }}">
                                            <input type="hidden" name="date" id="date-mobil">
                                            <input type="hidden" name="day" id="day-mobil">
                                            <input type="hidden" name="interval" id="interval-mobil">




                                            <div class="form-group">
                                                <label class="form-label">@lang('Metoda de plata')</label>
                                                <select class="form-control form--control form-select" name="payment_type"
                                                    required>
                                                    @if (auth()->user())
                                                        @if (auth()->user()->balance > 0)
                                                            <option value="1">@lang('Plata din Balanta Contului')
                                                                ({{ showAmount(auth()->user()->balance) }}
                                                                {{ $general->cur_text }})
                                                            </option>
                                                        @endif
                                                    @endif
                                                    <option value="2">@lang('Plata Card Online')</option>


                                                </select>
                                            </div>
                                            <div class="d-grid mt30">
                                                <button type="submit" class="ud-btn btn-thm">
                                                    Continua
                                                </button>
                                            </div>
                                        </form>


                                        <div class="price-content">

                                            <div class="h5 mb-2">
                                                @if ($service->influencer->skills)
                                                    @foreach ($service->influencer->skills as $skill)
                                                        <li>{{ __($skill) }}</li>
                                                    @endforeach
                                                @endif
                                            </div>


                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="d-none d-md-block">
                                <hr class="opacity-100 mb60">
                                <h4>Frequently Asked Questions</h4>
                                <div class="accordion-style1 faq-page mb-4 mb-lg-5 mt30">
                                    <div class="accordion" id="accordionExample">
                                        <div class="accordion-item active">
                                            <h2 class="accordion-header" id="headingOne">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">What methods of payments are
                                                    supported?</button>
                                            </h2>
                                            <div id="collapseOne" class="accordion-collapse collapse show"
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                                                    at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                                                    Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                                                    erat vel.</div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                    aria-expanded="false" aria-controls="collapseTwo">Can I cancel at
                                                    anytime?</button>
                                            </h2>
                                            <div id="collapseTwo" class="accordion-collapse collapse"
                                                aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                                                    at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                                                    Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                                                    erat vel.</div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                    aria-expanded="false" aria-controls="collapseThree">How do I get a
                                                    receipt for my purchase?</button>
                                            </h2>
                                            <div id="collapseThree" class="accordion-collapse collapse"
                                                aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                                                    at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                                                    Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                                                    erat vel.</div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingFour">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                                    aria-expanded="false" aria-controls="collapseFour">Which license do I
                                                    need?</button>
                                            </h2>
                                            <div id="collapseFour" class="accordion-collapse collapse"
                                                aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                                                    at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                                                    Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                                                    erat vel.</div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingFive">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseFive"
                                                    aria-expanded="false" aria-controls="collapseFive">How do I get access
                                                    to a theme I purchased?</button>
                                            </h2>
                                            <div id="collapseFive" class="accordion-collapse collapse"
                                                aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                                                    at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                                                    Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                                                    erat vel.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr class="opacity-100 mb60">
                            </div>


                            <hr class="opacity-100 mb15">
                            <div class="product_single_content mb50">
                                <div class="mbp_pagination_comments">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="total_review mb30 mt45">
                                                <h4>Reviews</h4>
                                            </div>
                                            <div class="d-md-flex align-items-center mb30">
                                                {{-- <div
                                                        class="total-review-box d-flex align-items-center text-center mb30-sm">
                                                        <div class="wrapper mx-auto">
                                                            <div class="t-review mb15">4.96</div>
                                                            <h5>Exceptional</h5>
                                                            <p class="text mb-0">3,014 reviews</p>
                                                        </div>
                                                    </div>
                                                    <div class="wrapper ml60 ml0-sm">
                                                        <div class="review-list d-flex align-items-center mb10">
                                                            <div class="list-number">5 Star</div>
                                                            <div class="progress">
                                                                <div class="progress-bar" style="width: 90%;"
                                                                    role="progressbar" aria-valuenow="90"
                                                                    aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="value text-end">58</div>
                                                        </div>
                                                        <div class="review-list d-flex align-items-center mb10">
                                                            <div class="list-number">4 Star</div>
                                                            <div class="progress">
                                                                <div class="progress-bar w-75" role="progressbar"
                                                                    aria-valuenow="75" aria-valuemin="0"
                                                                    aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="value text-end">20</div>
                                                        </div>
                                                        <div class="review-list d-flex align-items-center mb10">
                                                            <div class="list-number">3 Star</div>
                                                            <div class="progress">
                                                                <div class="progress-bar w-50" role="progressbar"
                                                                    aria-valuenow="50" aria-valuemin="0"
                                                                    aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="value text-end">15</div>
                                                        </div>
                                                        <div class="review-list d-flex align-items-center mb10">
                                                            <div class="list-number">2 Star</div>
                                                            <div class="progress">
                                                                <div class="progress-bar" style="width: 30%;"
                                                                    role="progressbar" aria-valuenow="30"
                                                                    aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="value text-end">2</div>
                                                        </div>
                                                        <div class="review-list d-flex align-items-center mb10">
                                                            <div class="list-number">1 Star</div>
                                                            <div class="progress">
                                                                <div class="progress-bar" style="width: 20%;"
                                                                    role="progressbar" aria-valuenow="10"
                                                                    aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="value text-end">1</div>
                                                        </div> --}}

                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            @foreach ($service->reviews as $review)
                                                <div
                                                    class="mbp_first position-relative d-flex align-items-center justify-content-start mb30-sm">
                                                    <img src="{{ getImage(getFilePath('userProfile') . '/' . @$review->user->image, getFileSize('userProfile'), true) }}"
                                                        class="mr-3" alt="comments-2.png">
                                                    <div class="ml20">
                                                        <h6 class="mt-0 mb-0">{{ __(@$review->user->fullname) }}</h6>
                                                        <div><span
                                                                class="fz14">{{ $review->created_at->format('d M Y') }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <p class="text mt20 mb20">{{ __($review->review) }}</p>
                                                <div class="review_cansel_btns d-flex">
                                                    <a href="#"><i class="fas fa-thumbs-up"></i>Helpful</a>
                                                    <a href="#"><i class="fas fa-thumbs-down"></i>Not
                                                        helpful</a>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="bsp_reveiw_wrt">
                                    <h6 class="fz17">Adaugă un Review</h6>
                                    <p class="text">Adresa de email nu va fi publicată. Câmpurile obligatorii sunt marcate cu *</p>
                                    <h6>Rating oferit</h6>
                                    <div class="d-flex">
                                        <i class="fas fa-star review-color"></i>
                                        <i class="far fa-star review-color ms-2"></i>
                                        <i class="far fa-star review-color ms-2"></i>
                                        <i class="far fa-star review-color ms-2"></i>
                                        <i class="far fa-star review-color ms-2"></i>
                                    </div>
                                    <form class="comments_form mt30 mb30-md">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="mb-4">
                                                    <label class="fw500 fz16 ff-heading dark-color mb-2">Comentariu</label>
                                                    <textarea class="pt15" rows="6"
                                                        placeholder="Lasă un comentariu."></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb20">
                                                    <label class="fw500 ff-heading dark-color mb-2">Nume</label>
                                                    <input type="text" class="form-control" placeholder="Adaugă numele tău">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb20">
                                                    <label class="fw500 ff-heading dark-color mb-2">Email</label>
                                                    <input type="email" class="form-control"
                                                        placeholder="exemplu-mail@mail.com">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <a href="" class="ud-btn btn-thm">Send<i
                                                        class="fal fa-arrow-right-long"></i></a>
                                            </div>
                                        </div>
                                    </form>
                                </div> --}}
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 d-none d-lg-block">
                    <div class="column">
                        <div class="blog-sidebar ms-lg-auto">
                            <div class="price-widget">
                                <div class="navtab-style1">
                                    <div class="row">
                                        <div class="col-6 d-flex justify-content-center align-items-center">
                                            <div class="price h-100">
                                                {{ $general->cur_sym }}{{ showAmount($service->price) }}

                                            </div>
                                        </div>
                                        <div class="col-6 d-flex justify-content-center align-items-center">
                                            <ul class="p-0 mb15 d-sm-flex align-items-center h-100">
                                                <li class="fz14 fw500 dark-color"><i
                                                        class="flaticon-sandclock fz20 text-thm2 me-2 vam"></i>40 Minute
                                                    {{-- <li class="fz14 fw500 dark-color ml20 ml0-xs"><i
                                                            class="flaticon-recycle fz20 text-thm2 me-2 vam"></i> --}}
                                            </ul>
                                        </div>
                                    </div>
                                    <form
                                        action="{{ route('user.order.confirm', [$service->influencer->id, $service->id]) }}"
                                        method="POST">
                                        @csrf



                                        <div id='calendar'>



                                        </div>

                                        <div id="available-times">

                                        </div>

                                        <textarea rows="6" class="form-control form--control mt-3" style="height:unset!important" name="description"
                                            id="description"
                                            placeholder="Scrie un mesaj pe care solver-ul sa il vada inainte de a accepta programarea ta......"></textarea>

                                        <input type="hidden" name="service_id" value="{{ $service->id }}">
                                        <input type="hidden" name="influencer_id"
                                            value="{{ $service->influencer->id }}">
                                        <input type="hidden" name="date" id="date">
                                        <input type="hidden" name="day" id="day">
                                        <input type="hidden" name="interval" id="interval">




                                        <div class="form-group">
                                            <label class="form-label">@lang('Metoda de plata')</label>
                                            <select class="form-control form--control form-select" name="payment_type"
                                                required>
                                                @if (auth()->user())
                                                    @if (auth()->user()->balance > 0)
                                                        <option value="1">@lang('Plata din Balanta Contului')
                                                            ({{ showAmount(auth()->user()->balance) }}
                                                            {{ $general->cur_text }})
                                                        </option>
                                                    @endif
                                                @endif
                                                <option value="2">@lang('Plata Card Online')</option>


                                            </select>
                                        </div>
                                        <div class="d-grid mt30">
                                            <button type="submit" class="ud-btn btn-thm">Continuă
                                                {{ $general->cur_sym }}{{ showAmount($service->price) }}<i
                                                    class="fal fa-arrow-right-long"></i></button>
                                        </div>
                                    </form>


                                    <div class="price-content">

                                        <div class="h5 mb-2">
                                            @if ($service->influencer->skills)
                                                @foreach ($service->influencer->skills as $skill)
                                                    <li>{{ __($skill) }}</li>
                                                @endforeach
                                            @endif
                                        </div>
                                        {{-- <p class="text fz14">I will redesign your current landing page or
                                                create one for you (upto 4 sections)</p> --}}


                                        {{-- <div class="list-style1">
                                                <ul class="">
                                                    <li class="mb15"><i
                                                            class="far fa-check text-thm3 bgc-thm3-light"></i>2
                                                        Page / Screen</li>
                                                    <li><i class="far fa-check text-thm3 bgc-thm3-light"></i>Source
                                                        file</li>
                                                </ul>
                                            </div> --}}

                                    </div>
                                    {{-- <div class="tab-content" id="nav-tabContent">
                                            <div class="tab-pane fade" id="nav-item1p" role="tabpanel"
                                                aria-labelledby="nav-item1p-tab">
                                                <div class="price-content">
                                                    <div class="price">$50</div>
                                                    <div class="h5 mb-2">High-converting Landing Pages</div>
                                                    <p class="text fz14">I will redesign your current landing page or
                                                        create one for you (upto 4 sections)</p>
                                                    <hr class="opacity-100 mb20">
                                                    <ul class="p-0 mb15 d-sm-flex align-items-center">
                                                        <li class="fz14 fw500 dark-color"><i
                                                                class="flaticon-sandclock fz20 text-thm2 me-2 vam"></i>3
                                                            Days Delivery</li>
                                                        <li class="fz14 fw500 dark-color ml20 ml0-xs"><i
                                                                class="flaticon-recycle fz20 text-thm2 me-2 vam"></i>2
                                                            Revisions</li>
                                                    </ul>
                                                    <div class="list-style1">
                                                        <ul class="">
                                                            <li class="mb15"><i
                                                                    class="far fa-check text-thm3 bgc-thm3-light"></i>2
                                                                Page / Screen</li>
                                                            <li><i class="far fa-check text-thm3 bgc-thm3-light"></i>Source
                                                                file</li>
                                                        </ul>
                                                    </div>
                                                    <div class="d-grid">
                                                        <a href="" class="ud-btn btn-thm">Continue $50<i
                                                                class="fal fa-arrow-right-long"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade show active" id="nav-item2p" role="tabpanel"
                                                aria-labelledby="nav-item2p-tab">
                                                <div class="price-content">
                                                    <div class="price">$29</div>
                                                    <div class="h5 mb-2">High-converting Landing Pages</div>
                                                    <p class="text fz14">I will redesign your current landing page or
                                                        create one for you (upto 4 sections)</p>
                                                    <hr class="opacity-100 mb20">
                                                    <ul class="p-0 mb15 d-sm-flex align-items-center">
                                                        <li class="fz14 fw500 dark-color"><i
                                                                class="flaticon-sandclock fz20 text-thm2 me-2 vam"></i>3
                                                            Days Delivery</li>
                                                        <li class="fz14 fw500 dark-color ml20 ml0-xs"><i
                                                                class="flaticon-recycle fz20 text-thm2 me-2 vam"></i>2
                                                            Revisions</li>
                                                    </ul>
                                                    <div class="list-style1">
                                                        <ul class="">
                                                            <li class="mb15"><i
                                                                    class="far fa-check text-thm3 bgc-thm3-light"></i>2
                                                                Page / Screen</li>
                                                            <li><i class="far fa-check text-thm3 bgc-thm3-light"></i>Source
                                                                file</li>
                                                        </ul>
                                                    </div>
                                                    <div class="d-grid">
                                                        <a href="" class="ud-btn btn-thm">Continue $29<i
                                                                class="fal fa-arrow-right-long"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="nav-item3p" role="tabpanel"
                                                aria-labelledby="nav-item3p-tab">
                                                <div class="price-content">
                                                    <div class="price">$250</div>
                                                    <div class="h5 mb-2">High-converting Landing Pages</div>
                                                    <p class="text fz14">I will redesign your current landing page or
                                                        create one for you (upto 4 sections)</p>
                                                    <hr class="opacity-100 mb20">
                                                    <ul class="p-0 mb15 d-sm-flex align-items-center">
                                                        <li class="fz14 fw500 dark-color"><i
                                                                class="flaticon-sandclock fz20 text-thm2 me-2 vam"></i>3
                                                            Days Delivery</li>
                                                        <li class="fz14 fw500 dark-color ml20 ml0-xs"><i
                                                                class="flaticon-recycle fz20 text-thm2 me-2 vam"></i>2
                                                            Revisions</li>
                                                    </ul>
                                                    <div class="list-style1">
                                                        <ul class="">
                                                            <li class="mb15"><i
                                                                    class="far fa-check text-thm3 bgc-thm3-light"></i>2
                                                                Page / Screen</li>
                                                            <li><i class="far fa-check text-thm3 bgc-thm3-light"></i>Source
                                                                file</li>
                                                        </ul>
                                                    </div>
                                                    <div class="d-grid">
                                                        <a href="" class="ud-btn btn-thm">Continue $250<i
                                                                class="fal fa-arrow-right-long"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> --}}
                                </div>
                            </div>
                            <div class="freelancer-style1 service-single mb-0">
                                <div class="wrapper d-flex align-items-center">
                                    <div class="thumb position-relative mb25">
                                        <img class="rounded-circle mx-auto"
                                            src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                            alt="" style="width: 100px; height: 100px;">
                                        <span class="online"></span>
                                    </div>
                                    <div class="ml20">
                                        <h5 class="title mb-1">{{ __(@$service->influencer->fullname) }}</h5>
                                        <p class="mb-0">{{ __(@$service->influencer->profession) }}</p>
                                        <div class="review">
                                            <p><i class="fas fa-star fz10 review-color pr10"></i><span
                                                    class="dark-color">{{ @$service->influencer->rating }}</span>
                                                ({{ getAmount(@$service->influencer->total_review) ?? 0 }})</p>
                                        </div>
                                    </div>
                                </div>
                                <hr class="opacity-100">
                                <div class="details">
                                    <div class="fl-meta d-flex align-items-center justify-content-between">
                                        <a class="meta fw500 text-start">Oraș<br><span
                                                class="fz14 fw400">{{ $service->influencer->address->city }}</span></a>
                                        <a class="meta fw500 text-start">Cost<br><span
                                                class="fz14 fw400">{{ $general->cur_sym }}{{ showAmount($service->price) }}
                                                /
                                                40 Minute</span></a>
                                        {{-- <a class="meta fw500 text-start">Job Success<br><span
                                                    class="fz14 fw400">%98</span></a> --}}
                                    </div>
                                </div>
                                <div class="d-grid mt30">
                                    <a href="{{ route('influencer.profile', ['name' => $service->influencer->username, 'id' => $service->influencer->id]) }}"
                                        class="ud-btn btn-thm-border">Contact<i class="fal fa-arrow-right-long"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Listings -->
    <section class="pt30 pb90 pb30-md">
        <div class="container">
            <div class="row wow fadeInUp">
                <div class="col-lg-12">
                    <div class="main-title mb35">
                        <h2>Listari Sugerate</h2>
                        {{-- <p class="text">Give your visitor a smooth online experience with a solid UX design</p> --}}
                    </div>
                </div>
            </div>
            <div class="row wow fadeInUp">

                <div class="col-lg-12">
                    <div class="navpill-style2">
                        <div class="tab-content ha" id="pills-tabContent">
                            <div class="tab-pane fade fz15 text show active" id="pills-home" role="tabpanel"
                                aria-labelledby="pills-home-tab">
                                <div class="row">

                                    @php
                                        $servicePropular = getContent('service.content', true);
                                        $servicesPropular = App\Models\Service::approved()
                                            ->with('influencer', 'category')
                                            ->latest()
                                            ->orderBy('rating', 'desc')
                                            ->take(20)
                                            ->get();
                                    @endphp
                                    @if ($servicesPropular->count() > 0)
                                        @foreach ($servicesPropular as $single_service)
                                            <div class="col-sm-6 col-xl-3">
                                                <div class="listing-style1 default-box-shadow1 bdrs16">
                                                    <div class="list-thumb">
                                                        <a href="{{ route('service.details', [slug($single_service->title), $single_service->id]) }}">
                                                            <img class="w-100"
                                                                    src="{{ getImage(getFilePath('service') . '/thumb_' . $single_service->image, getFileThumb('service')) }}"
                                                                    alt="images">
                                                        </a>
                                                    </div>
                                                    <div class="list-content">
                                                        <p class="list-text body-color fz14 mb-1">
                                                            {{-- {{ __(@$single_service->category->name) }}</p> --}}
                                                        <h5 class="list-title"><a
                                                                href="{{ route('service.details', [slug($single_service->title), $single_service->id]) }}">{{ __(@$single_service->title) }}</a>
                                                        </h5>
                                                        <div class="review-meta d-flex align-items-center">
                                                            <i class="fas fa-star fz10 review-color me-2"></i>
                                                            <p class="mb-0 body-color fz14">
                                                                <span
                                                                    class="dark-color me-2">{{ $single_service->rating }}</span>{{ $single_service->reviews_count ?? 0 }}
                                                                reviews
                                                            </p>
                                                        </div>
                                                        <hr class="my-2">
                                                        <div
                                                            class="list-meta d-flex justify-content-between align-items-center mt15">
                                                            <a
                                                                href="{{ route('influencer.profile', [slug($single_service->influencer->username), $single_service->influencer->id]) }}">
                                                                <span class="position-relative mr10">
                                                                    <img class="rounded-circle"
                                                                        src="{{ getImage(getFilePath('influencerProfile') . '/' . @$single_service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                                                        alt="Freelancer Photo"
                                                                        style="width: 40px; height: 40px;">
                                                                    <span class="online-badge"></span>
                                                                </span>
                                                                <span
                                                                    class="fz14">{{ __(@$single_service->influencer->username) }}</span>
                                                            </a>
                                                            <div class="budget">
                                                                <p class="mb-0 body-color">Starting at<span
                                                                        class="fz17 fw500 dark-color ms-1">{{ showAmount($single_service->price) }}</span>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="d-block d-md-none">
        <hr class="opacity-100 mb60">
        <h4>Frequently Asked Questions</h4>
        <div class="accordion-style1 faq-page mb-4 mb-lg-5 mt30">
            <div class="accordion" id="accordionExample">
                <div class="accordion-item active">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">What methods
                            of payments are
                            supported?</button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                            at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                            Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                            erat vel.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">Can I cancel
                            at
                            anytime?</button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                            at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                            Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                            erat vel.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">How do I
                            get a
                            receipt for my purchase?</button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                            at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                            Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                            erat vel.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">Which
                            license do I
                            need?</button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                            at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                            Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                            erat vel.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">How do I
                            get access
                            to a theme I purchased?</button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">Cras vitae ac nunc orci. Purus amet tortor non
                            at phasellus ultricies hendrerit. Eget a, sit morbi nunc sit id massa.
                            Metus, scelerisque volutpat nec sit vel donec. Sagittis, id volutpat
                            erat vel.</div>
                    </div>
                </div>
            </div>
        </div>
        <hr class="opacity-100 mb60">
    </div>
    <!-- Our Footer -->

    {{-- on mobile we have a bottom bar with a "Rezerva" button --}}
    <div class="bottom-bar d-lg-none">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>
                            {{ $general->cur_sym }} {{ showAmount($service->price) }}
                        </span>
                        <a href="#orderFormMobil" class="ud-btn btn-thm">Rezerva <i
                                class="fal fa-arrow-right-long"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .bottom-bar {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #fff;
            z-index: 9999;
            padding: 10px 20px;
            box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.1);
        }

        .scrollToHome {
            position: fixed;
            bottom: 80px;
            right: 20px;
            background-color: #007bff;
            color: #fff;
            border-radius: 50%;
            padding: 10px;
            font-size: 24px;
            display: none;
            /* Initially hidden */
        }

        .scrollToHome:hover {
            background-color: #0056b3;
        }

        .scrollToHome i {
            color: #fff;
        }

        .scrollToHome:active {
            background-color: #0056b3;
        }

        .scrollToHome:focus {
            outline: none;
        }
    </style>
    <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>

    @push('script')
        <script>
            var availableDates = JSON.parse(@json($service->schedule));
            new AirDatepicker('#calendar', {
                autoClose: true,
                dateSelected: new Date(),
                minDate: new Date(new Date().getTime()),
                locale: {
                    days: ['Duminică', 'Luni', 'Marți', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă'],
                    daysShort: ['Dum', 'Lun', 'Mar', 'Mie', 'Joi', 'Vin', 'Sâm'],
                    daysMin: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
                    months: ['Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie', 'Iulie', 'August',
                        'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'
                    ],
                    monthsShort: ['Ian', 'Feb', 'Mar', 'Apr', 'Mai', 'Iun', 'Iul', 'Aug', 'Sep', 'Oct',
                        'Nov', 'Dec'
                    ],
                    today: 'Astăzi',
                    clear: 'Șterge',
                    firstDay: 1
                },
                format: 'dd MMMM yyyy',
                onSelect: function(fd, d, picker) {
                    console.log('Selected date:', fd.formattedDate);
                    // we clear the inputs of day and interval
                    $('#date').val('');
                    $('#interval').val('');
                    // we get the day of the week from the date
                    var dayOfWeek = new Date(fd.date).getDay();
                    let days = ['duminică', 'luni', 'marți', 'miercuri', 'joi', 'vineri', 'sâmbătă'];
                    console.log('Day of the week:', days[dayOfWeek]);
                    // we make a button for each of the available times
                    var availableTimes = availableDates[days[dayOfWeek]];

                    // we get the lengsth of the available times so we make 2 columns
                    var columnCount = Math.ceil(availableTimes.length / 2);
                    var column1 = availableTimes.slice(0, columnCount);
                    var column2 = availableTimes.slice(columnCount);
                    // we make a button for each of the available times
                    let buttons = '<div class="row">';
                    // we start the first column
                    buttons += '<div class="col-md-6 d-flex justify-content-center flex-wrap">';
                    for (var i = 0; i < column1.length; i++) {
                        buttons +=
                            '<button type="button" class="btn btn-outline-secondary w-100 toggle-btn m-1" data-day="' +
                            days[dayOfWeek] + '" data-time="' + column1[i] + '">' + column1[i] +
                            '</button>';
                    }
                    buttons += '</div>';
                    // we start the second column
                    buttons += '<div class="col-md-6" d-flex justify-content-center flex-wrap">';
                    for (var i = 0; i < column2.length; i++) {
                        buttons +=
                            '<button  type="button" class="btn btn-outline-secondary w-100 toggle-btn m-1" data-day="' +
                            days[dayOfWeek] + '" data-time="' + column2[i] + '">' + column2[i] +
                            '</button>';
                    }
                    buttons += '</div>';


                    // we add the buttons to the div with the id of available-times
                    $('#available-times').html(buttons);

                    $('.toggle-btn').on('click', function() {
                        // we remove the class active from all buttons
                        $('.toggle-btn').removeClass('active');
                        // we toggle the class active on the clicked button
                        $(this).toggleClass('active');
                        // we get the data-day and data-time from the clicked button and set the values to the inputs
                        var day = $(this).data('day');
                        var time = $(this).data('time');
                        $('#day').val(day);
                        $('#date').val(fd.formattedDate);
                        $('#interval').val(time);
                        console.log('Selected date:', day);
                        console.log('Selected time:', time);

                    });
                }

            });
            //  Fixed sidebar Custom Script For That 
            $(function() {
                var cols = $('.wrap .column');
                var enabled = true;
                var scrollbalance = new ScrollBalance(cols, {
                    minwidth: 1199
                });
                // bind to scroll and resize events
                scrollbalance.bind();
            });

            new AirDatepicker('#calendar-mobil', {
                autoClose: true,
                dateSelected: new Date(),
                minDate: new Date(new Date().getTime()),
                locale: {
                    days: ['Duminică', 'Luni', 'Marți', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă'],
                    daysShort: ['Dum', 'Lun', 'Mar', 'Mie', 'Joi', 'Vin', 'Sâm'],
                    daysMin: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
                    months: ['Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie', 'Iulie', 'August',
                        'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'
                    ],
                    monthsShort: ['Ian', 'Feb', 'Mar', 'Apr', 'Mai', 'Iun', 'Iul', 'Aug', 'Sep', 'Oct',
                        'Nov', 'Dec'
                    ],
                    today: 'Astăzi',
                    clear: 'Șterge',
                    firstDay: 1
                },
                format: 'dd MMMM yyyy',
                onSelect: function(fd, d, picker) {
                    console.log('Selected date:', fd.formattedDate);
                    // we clear the inputs of day and interval
                    $('#date-mobil').val('');
                    $('#interval-mobil').val('');
                    // we get the day of the week from the date
                    var dayOfWeek = new Date(fd.date).getDay();
                    let days = ['duminică', 'luni', 'marți', 'miercuri', 'joi', 'vineri', 'sâmbătă'];
                    console.log('Day of the week:', days[dayOfWeek]);
                    // we make a button for each of the available times
                    var availableTimes = availableDates[days[dayOfWeek]];

                    // we get the lengsth of the available times so we make 2 columns
                    var columnCount = Math.ceil(availableTimes.length / 2);
                    var column1 = availableTimes.slice(0, columnCount);
                    var column2 = availableTimes.slice(columnCount);
                    // we make a button for each of the available times
                    let buttons = '<div class="row">';
                    // we start the first column
                    buttons += '<div class="col-md-6 d-flex justify-content-center flex-wrap">';
                    for (var i = 0; i < column1.length; i++) {
                        buttons +=
                            '<button type="button" class="btn btn-outline-secondary w-100 toggle-btn m-1" data-day="' +
                            days[dayOfWeek] + '" data-time="' + column1[i] + '">' + column1[i] +
                            '</button>';
                    }
                    buttons += '</div>';
                    // we start the second column
                    buttons += '<div class="col-md-6" d-flex justify-content-center flex-wrap">';
                    for (var i = 0; i < column2.length; i++) {
                        buttons +=
                            '<button  type="button" class="btn btn-outline-secondary w-100 toggle-btn m-1" data-day="' +
                            days[dayOfWeek] + '" data-time="' + column2[i] + '">' + column2[i] +
                            '</button>';
                    }
                    buttons += '</div>';


                    // we add the buttons to the div with the id of available-times
                    $('#available-times-mobil').html(buttons);

                    $('.toggle-btn').on('click', function() {
                        // we remove the class active from all buttons
                        $('.toggle-btn').removeClass('active');
                        // we toggle the class active on the clicked button
                        $(this).toggleClass('active');
                        // we get the data-day and data-time from the clicked button and set the values to the inputs
                        var day = $(this).data('day');
                        var time = $(this).data('time');
                        $('#day-mobil').val(day);
                        $('#date-mobil').val(fd.formattedDate);
                        $('#interval-mobil').val(time);
                        console.log('Selected date:', day);
                        console.log('Selected time:', time);

                    });
                }

            });
            //  Fixed sidebar Custom Script For That 
            $(function() {
                var cols = $('.wrap .column');
                var enabled = true;
                var scrollbalance = new ScrollBalance(cols, {
                    minwidth: 1199
                });
                // bind to scroll and resize events
                scrollbalance.bind();
            });
        </script>
    @endpush
@endsection
