<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $general->siteName(__(isset($customPageTitle) ? $customPageTitle : $pageTitle)) }}</title>
    @include('partials.seo')


    <link rel="icon" type="image/png" href="{{ getImage(getFilePath('logoIcon') . '/favicon.png', '?' . time()) }}"
        sizes="16x16">
    <link rel="stylesheet" href="{{ asset('theme/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/jquery-ui.min.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/ace-responsive-menu.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/menu.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/flaticon.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/bootstrap-select.min.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/animate.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/slider.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('theme/css/ud-custom-spacing.css') }}">
    <!-- Responsive stylesheet -->
    <link rel="stylesheet" href="{{ asset('theme/css/responsive.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/air-datepicker@3.5.3/air-datepicker.min.css" rel="stylesheet">
    @stack('style-lib')

    @stack('style')
    <style>
        .ace-responsive-menu>li>a {

            text-transform: unset !important;
        }

        .ace-responsive-menu>li>a:hover {
            color: #2f743e;
        }

        a.login-info {
            border-radius: 100px;
            padding: 5px 10px;
            /* border: 1px solid #000; */
        }

        a.logo1 img {
            max-width: 100px !important;
            max-height: 100px !important;
        }

        a.mobile_logo img {
            max-width: 140px !important;
            max-height: 70px !important;
        }
    </style>
</head>

<body>
    <div class="wrapper ovh">
        <div class="preloader"></div>

        <!-- Main Header Nav -->
        <header class="header-nav nav-innerpage-style menu-home4 dashboard_header main-menu">
            <!-- Ace Responsive Menu -->
            <nav class="posr">
                <div class="container posr">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-7 px-0 px-xl-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="logos">
                                    <div class="row">
                                        <div class="col-4">
                                            <a class="mobile_logo" href="/">
                                                <img src="{{ asset('assets/SolveetIcon.png') }}" alt="Header Logo">
                                            </a>
                                        </div>
                                        <div class="col-8 p-0 d-flex justify-content-center align-items-center">
                                           
                                            <a class="mobile_logo" href="/">
                                                <img src="{{ asset('assets/SolveetText.png') }}" alt="Header Logo">
                                            </a>
                                        </div>
                                    </div>
                                    {{-- <a class="header-logo logo1" href="/">
                                        <img src="{{ asset('assets/Solveet.png') }}" alt="Header Logo">
                                    </a> --}}

                                </div>

                                <!-- Responsive Menu Structure-->
                                <ul id="respMenu" class="ace-responsive-menu" data-menu-style="horizontal">
                                    <li><a href="/">Home</a></li>
                                    <li><a href="/services">Find a Solver</a></li>
                                    <li><a href="/about">About us</a></li>
                                    <li> <a class="list-item pe-0" href="/contact">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-5 pe-0 pe-xl-3">
                            @if (!empty(authInfluencer()))
                                <div class="d-flex align-items-center flex-wrap justify-content-end">

                                    <a class="login-info mx15-xl mx30  text-center ud-btn btn-thm"
                                        href="{{ route('influencer.home') }}">Solver Panel</a>


                                </div>
                            @elseif(auth()->check())
                                <div class="d-flex align-items-center flex-wrap justify-content-end">
                                    <a class="login-info mr15-xl mr30 ud-btn btn-thm"
                                        href="{{ route('influencer.become') }}">Become a Solver</a>
                                    <a class="login-info mx15-xl mx30  text-center ud-btn btn-thm"
                                        href="{{ route('user.home') }}">Client Panel</a>


                                </div>
                            @else
                                <div class="d-flex align-items-center flex-wrap justify-content-end">
                                    <a class="login-info mx15-xl mx30  text-center ud-btn btn-thm"
                                        href="{{ route('user.register') }}">You new? Sign-up Now! </a>
                                    <a class="login-info mr15-xl mr30 ud-btn btn-thm"
                                        href="{{ route('user.login') }}">Got an account? Log-in</a>

                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </nav>
        </header>


        <div id="page" class="mobilie_header_nav stylehome1">
            <div class="mobile-menu">
                <div class="header bdrb1">
                    <div class="menu_and_widgets">
                        <div class="row p-0">
                            <div class="col-3">
                                <a class="mobile_logo" href="/">
                                    <img src="{{ asset('assets/SolveetIcon.png') }}" alt="Header Logo">
                                </a>
                            </div>
                            <div class="col-6 p-0 d-flex justify-content-center">
                                <a class="mobile_logo" href="/">
                                    <img src="{{ asset('assets/SolveetText.png') }}" alt="Header Logo">
                                </a>
                            </div>
                            <div class="col-3">
                                <div class="right-side text-end">
                                    {{-- <a class="" href="page-login.html">join</a> --}}
                                    <a class="menubar ml30" href="#menu"><img
                                            src="{{ asset('theme/images/mobile-dark-nav-icon.svg') }}"
                                            alt=""></a>
                                </div>
                            </div>
                        </div>
                        <div class="mobile_menu_bar d-flex justify-content-between align-items-center">




                        </div>
                    </div>
                    <div class="posr">
                        <div class="mobile_menu_close_btn"><span class="far fa-times"></span></div>
                    </div>
                </div>
            </div>
            <!-- /.mobile-menu -->
            <nav id="menu" class="">
                <ul>
                    <li><a href="/">Pagină Principală</a></li>
                    <li><a href="/services">Găseste un Solver</a></li>
                    <li><a href="/about">Despre Noi</a></li>
                    <li> <a class="list-item pe-0" href="/contact">Contact</a></li>
                    @if (!empty(authInfluencer()))
                        <li style="margin-top: 5px !important;"><a class="login-info text-center ud-btn btn-thm"
                                href="{{ route('influencer.home') }}">Panou de control Solver</a></li>
                    @elseif(auth()->check())
                        <li style="margin-top: 50px !important;"><a class="login-info ud-btn btn-thm"
                                href="{{ route('influencer.become') }}">Vreau să devin Solver</a></li>
                        <li style="margin-top: 5px !important;"><a class="login-info text-center ud-btn btn-thm"
                                href="{{ route('user.home') }}">Profil</a></li>
                    @else
                        <li style="margin-top: 50px !important;"><a class="login-info text-center ud-btn btn-thm"
                                href="{{ route('user.register') }}">Ești nou? Începe acum!</a></li>
                        <li style="margin-top: 5px !important;"><a class=" login-info ud-btn btn-thm"
                                href="{{ route('user.login') }}">Ai deja cont? Intră aici</a></li>
                    @endif

                </ul>
            </nav>
        </div>

        @stack('fbComment')



        @yield('app')

        @php
            $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
        @endphp
        @if ($cookie->data_values->status == 1 && !\Cookie::get('gdpr_cookie'))
            <div class="cookies-card text-center hide">
                <div class="cookies-card__icon bg--base">
                    <i class="las la-cookie-bite"></i>
                </div>
                <p class="mt-4 cookies-card__content">{{ $cookie->data_values->short_desc }}
                    <a href="{{ route('cookie.policy') }}" target="_blank" class="text--base">@lang('learn more')</a>
                </p>
                <div class="cookies-card__btn mt-4">
                    <a href="javascript:void(0)" class="btn btn--base w-100 policy">@lang('Allow')</a>
                </div>
            </div>
        @endif


        <section class="footer-style1 at-home6 home2-footer-radius pt25 pb-0">
            <div class="container">
                <div class="row bb-white-light pb10 mb60">
                    <div class="col-md-7">
                        <div
                            class="d-block text-center text-md-start justify-content-center justify-content-md-start d-md-flex align-items-center mb-3 mb-md-0">
                            <a class="fz17 fw500 text-white mr15-md mr30" href="">Terms of Service</a>
                            <a class="fz17 fw500 text-white mr15-md mr30" href="">Privacy Policy</a>
                            <a class="fz17 fw500 text-white" href="">Site Map</a>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="social-widget text-center text-md-end">
                            <div class="social-style1">
                                <a class="text-white me-2 fw500 fz17" href="">Follow us</a>
                                <a href=""><i class="fab fa-facebook-f list-inline-item"></i></a>
                                <a href=""><i class="fab fa-twitter list-inline-item"></i></a>
                                <a href=""><i class="fab fa-instagram list-inline-item"></i></a>
                                <a href=""><i class="fab fa-linkedin-in list-inline-item"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 col-lg-3">
                        <div class="link-style1 mb-4 mb-sm-5">
                            <h5 class="text-white mb15">About</h5>
                            <div class="link-list">
                                <a href="">Careers</a>
                                <a href="">Press & News</a>
                                <a href="">Partnerships</a>
                                <a href="">Privacy Policy</a>
                                <a href="">Terms of Service</a>
                                <a href="">Investor Relations</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="link-style1 mb-4 mb-sm-5">
                            <h5 class="text-white mb15">Categories</h5>
                            <ul class="ps-0">
                                <li><a href="">Graphics & Design</a></li>
                                <li><a href="">Digital Marketing</a></li>
                                <li><a href="">Writing & Translation</a></li>
                                <li><a href="">Video & Animation</a></li>
                                <li><a href="">Music & Audio</a></li>
                                <li><a href="">Programming & Tech</a></li>
                                <li><a href="">Data</a></li>
                                <li><a href="">Business</a></li>
                                <li><a href="">Lifestyle</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="link-style1 mb-4 mb-sm-5">
                            <h5 class="text-white mb15">Support</h5>
                            <ul class="ps-0">
                                <li><a href="">Help & Support</a></li>
                                <li><a href="">Trust & Safety</a></li>
                                <li><a href="">Selling on Freeio</a></li>
                                <li><a href="">Buying on Freeio</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="footer-widget">
                            <div class="footer-widget mb-4 mb-sm-5">
                                <div class="mailchimp-widget">
                                    <h5 class="title text-white mb20">Subscribe</h5>
                                    <div class="mailchimp-style1">
                                        <input type="email" class="form-control bdrs4"
                                            placeholder="Your email address">
                                        <button type="submit">Send</button>
                                    </div>
                                </div>
                            </div>
                            <div class="app-widget mb-4 mb-sm-5">
                                <h5 class="title text-white mb20">Apps</h5>
                                <div class="row mb-4 mb-lg-5">
                                    <div class="col-lg-12">
                                        <a class="app-list d-flex align-items-center mb10" href="">
                                            <i class="fab fa-apple fz17 mr15"></i>
                                            <h6 class="app-title fz15 fw400 mb-0">iOS App</h6>
                                        </a>
                                        <a class="app-list d-flex align-items-center" href="">
                                            <i class="fab fa-google-play fz15 mr15"></i>
                                            <h6 class="app-title fz15 fw400 mb-0">Android App</h6>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container white-bdrt1 py-4">
                <div class="row">
                    <div class="col-md-6">
                        <div class="text-center text-lg-start">
                            <p class="copyright-text mb-0 text-white-light ff-heading">© Freeio. 2023 CreativeLayers.
                                All rights
                                reserved.</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="footer_bottom_right_btns text-center text-lg-end">
                            <ul class="p-0 m-0">
                                <li class="list-inline-item">
                                    <select class="selectpicker show-tick">
                                        <option>US$ USD</option>
                                        <option>Euro</option>
                                        <option>Pound</option>
                                    </select>
                                </li>
                                <li class="list-inline-item">
                                    <select class="selectpicker show-tick">
                                        <option>English</option>
                                        <option>Frenc</option>
                                        <option>Italian</option>
                                        <option>Spanish</option>
                                        <option>Turkey</option>
                                    </select>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <a class="scrollToHome at-home2" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
    </div>

    {{-- we make a floating bar with icons --}}

    <!-- Wrapper End -->
    <script src="{{ asset('theme/js/jquery-3.6.4.min.js') }}"></script>
    <script src="{{ asset('theme/js/jquery-migrate-3.0.0.min.js') }}"></script>
    <script src="{{ asset('theme/js/popper.min.js') }}"></script>
    <script src="{{ asset('theme/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('theme/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('theme/js/jquery.mmenu.all.js') }}"></script>
    <script src="{{ asset('theme/js/ace-responsive-menu.js') }}"></script>
    <script src="{{ asset('theme/js/jquery-scrolltofixed-min.js') }}"></script>
    <script src="{{ asset('theme/js/wow.min.js') }}"></script>
    <script src="{{ asset('theme/js/owl.js') }}"></script>
    <script src="{{ asset('theme/js/scrollbalance.js') }}"></script>
    <script src="{{ asset('theme/js/jquery.counterup.js') }}"></script>
    <script src="{{ asset('theme/js/pricing-table.js') }}"></script>
    {{-- <script src="{{ asset('theme/js/pricing-slider.js')}}"></script>  --}}
    <!-- Custom script for all pages -->
    <script src="{{ asset('theme/js/script.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/air-datepicker@3.5.3/air-datepicker.min.js"></script>

    @stack('script-lib')

    @stack('script')

    @include('partials.notify')

    @include('partials.plugins')



    <!-- Pluglin Link -->
    <script src="{{ asset($activeTemplateTrue . 'js/lib/slick.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/lib/magnific-popup.min.js') }}"></script>

    <!-- Main js -->
    <script src="{{ asset($activeTemplateTrue . 'js/lib/chart.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>

    <script src="{{ asset($activeTemplateTrue . 'js/main.js') }}"></script>

    <script>
        bkLib.onDomLoaded(function() {
            $(".nicEdit").each(function(index) {
                $(this).attr("id", "nicEditor" + index);
                new nicEditor({
                    fullPanel: true
                }).panelInstance('nicEditor' + index, {
                    hasPanel: true
                });
            });
        });
        (function($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "{{ route('home') }}/change/" + $(this).val();
            });

            $('.policy').on('click', function() {
                $.get('{{ route('cookie.accept') }}', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {

                if (element.hasAttribute('required')) {
                    $(element).closest('.form-group').find('label').addClass('required');
                }

            });

            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

            // Sticky Menu
            let logo = `{{ getImage(getFilePath('logoIcon') . '/logo.png') }}`;
            let logoDark = `{{ getImage(getFilePath('logoIcon') . '/logo_dark.png') }}`;


        })(jQuery);
    </script>



</body>

</html>
