@php
    $kycContent = getContent('influencer_kyc.content', true);
@endphp
@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    @if (authInfluencer()->kv == 0)
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification required')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->verification_content) }}
                <a href="{{ route('influencer.kyc.form') }}" class="text--base">@lang('Click Here to Verify')</a>
            </p>
        </div>
    @elseif(authInfluencer()->kv == 2)
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->pending_content) }}
                <a href="{{ route('influencer.kyc.data') }}" class="text--base">@lang('See KYC Data')</a>
            </p>
        </div>
    @endif
    <div class="wrapper">
        <div class="preloader"></div>


        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'influencer.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                         
                            <div class="col-lg-12">
                                <div class="dashboard_title_area">
                                    <h2>Retrage Fonduri</h2>
                                    
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="card-body">
                                        <form action="{{ route('influencer.withdraw.money') }}" method="post"
                                            class="from row gy-2">
                                            @csrf
                                            <div class="form-group">
                                                {{-- we display the influencer ballance  --}}
                                                <label class="form-label
                                                    text--base">@lang('Your Balance') : <span
                                                        class="text--success">{{ showAmount(authInfluencer()->balance) }}
                                                        {{ __($general->cur_text) }}</span></label>
                                                <input type="hidden" name="balance"
                                                    value="{{ authInfluencer()->balance }}">
                                            </div>
                                                <label class="form-label">@lang('Withdraw Method')</label>
                                                <select class="form-control form--control form-select" name="method_code"
                                                    required>
                                                    <option value="">@lang('Select Gateway')</option>
                                                    @foreach ($withdrawMethod as $data)
                                                        <option value="{{ $data->id }}"
                                                            data-resource="{{ $data }}">
                                                            {{ __($data->name) }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">@lang('Amount')</label>
                                                <div class="input-group">
                                                    <input type="number" step="any" name="amount"
                                                        value="{{ old('amount') }}" class="form-control form--control"
                                                        required>
                                                    <span class="input-group-text">{{ $general->cur_text }}</span>
                                                </div>
                                            </div>
                                            <div class="preview-details d-none my-3">
                                                <ul class="list-group-flush text-center">
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Limit')</span>
                                                        <span><span class="min fw-bold">0</span>
                                                            {{ __($general->cur_text) }} - <span
                                                                class="max fw-bold">0</span>
                                                            {{ __($general->cur_text) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Charge')</span>
                                                        <span><span class="charge fw-bold">0</span>
                                                            {{ __($general->cur_text) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Receivable')</span> <span><span
                                                                class="receivable fw-bold"> 0</span>
                                                            {{ __($general->cur_text) }} </span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between rate-element">

                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between in-site-cur">
                                                        <span>@lang('In') <span class="base-currency"></span></span>
                                                        <strong class="final_amo">0</strong>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div
                                                style="align-items: center; display: flex; justify-content: space-between; flex-direction: column; margin-top: 20px;">
                                                <button type="submit"
                                                    class="ud-btn btn-dark default-box-shadow2">@lang('Submit')</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </footer>
                </div>
            </div>
        </div>
        <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
@endsection
