@php
    $kycContent = getContent('influencer_kyc.content', true);
@endphp
@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    @if (authInfluencer()->kv == 0)
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification required')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->verification_content) }}
                <a href="{{ route('influencer.kyc.form') }}" class="text--base">@lang('Click Here to Verify')</a>
            </p>
        </div>
    @elseif(authInfluencer()->kv == 2)
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->pending_content) }}
                <a href="{{ route('influencer.kyc.data') }}" class="text--base">@lang('See KYC Data')</a>
            </p>
        </div>
    @endif
    <div class="wrapper">
        <div class="preloader"></div>

        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'influencer.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            <div class="col-lg-9">
                                <div class="dashboard_title_area">

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="row mb10">
                                        <div class="col-lg-6 d-flex justify-content-start">
                                            <h4> [@lang('Ticket')#{{ $myTicket->ticket }}]
                                                {{ $myTicket->subject }}
                                                @if ($myTicket->status == 0)
                                                <span class="pending-style style1">@lang('Deschis')</span>
                                              @elseif ($myTicket->status == 1)
                                                <span class="pending-style style2">@lang('Raspuns')</span>
                                              @elseif ($myTicket->status == 2)
                                                <span class="pending-style style2">@lang('Trimis')</span>
                                                @elseif ($myTicket->status == 3)
                                                <span class="pending-style style3">@lang('Închis')</span>
                                              @endif</h4>
                                                
                                        </div>
                                        <div class="col-lg-6 d-flex justify-content-end">
                                            @if ($myTicket->status != 3 && $myTicket->influencer)
                                                <a href="{{ route('influencer.ticket.close', $myTicket->id) }}" 
                                                    class="pending-style style3 d-inline-flex align-items-center"
                                                    data-question="@lang('Ești sigur că vrei să anulezi tichetul?')">
                                                     <i class="fa-regular fa-times-circle mr5"></i> @lang('Anulează Tichetul') 
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        @if ($myTicket->status != 4)
                                            <form class="form-style1" action="{{ route('ticket.reply', $myTicket->id) }}"
                                                method="post" enctype="multipart/form-data">
                                                @csrf
                                                <div class="row justify-content-between">
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <textarea name="message" class="form-control form--control shadow-none" id="inputMessage"
                                                                placeholder="@lang('Mesajul')" rows="4" cols="10">{{ old('message') }}</textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label for="inputAttachments"
                                                                class="form-label">@lang('Attachments')</label>
                                                            <small class="text-danger">@lang('Max 5 files can be uploaded'). @lang('Maximum upload size is')
                                                                {{ ini_get('upload_max_filesize') }}</small>
                                                            <div class="d-flex gap-2">
                                                                <input type="file" name="attachments[]"
                                                                    id="inputAttachments"
                                                                    class="form--control form-control radius-5">
                                                                <a href="javascript:void(0)"
                                                                    class="btn btn--base d-flex align-items-center addFile">
                                                                    <i class="las la-plus"></i>
                                                                </a>
                                                            </div>
                                                            <div id="fileUploadsContainer"></div>
                                                            <p class="ticket-attachments-message text-muted mt-1">
                                                                @lang('Allowed File Extensions'): .@lang('jpg'),
                                                                .@lang('jpeg'), .@lang('png'),
                                                                .@lang('pdf'),
                                                                .@lang('doc'), .@lang('docx')
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <button type="submit" class="table-action fz15 fw500 text-thm2">
                                                            <i class="fa fa-reply"></i> @lang('Trimite')
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        @endif
                                    </div>
                                </div>
                                </footer>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                @foreach ($messages as $message)
                                    @if ($message->admin_id == 0)
                                        <div
                                            class="row border-primary border-radius-3 ticket-reply-user my-sm-3 mx-sm-2 my-2 mx-0 border py-3">
                                            <div class="col-md-3 border--right text-right">
                                                <h5 class="text--base my-3">{{ @$message->ticket->name }}</h5>
                                            </div>
                                            <div class="col-md-9 ps-2">
                                                <p class="text-muted fw-bold">
                                                    @lang('Posted on')
                                                    {{ $message->created_at->format('l, dS F Y @ H:i') }}
                                                </p>
                                                <p>
                                                    {{ $message->message }}
                                                </p>
                                                @if ($message->attachments->count() > 0)
                                                    <div class="mt-2">
                                                        @foreach ($message->attachments as $k => $image)
                                                            <a href="{{ route('influencer.ticket.download', encrypt($image->id)) }}"
                                                                class="text--base mr-3"><i class="fa fa-file"></i>
                                                                @lang('Attachment') {{ ++$k }} </a>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @else
                                        <div
                                            class="row border-warning border-radius-3 my-sm-3 mx-sm-2 my-2 mx-0 border py-3">
                                            <div class="col-md-3 border--right text-right">
                                                <h5 class="text--base my-3">{{ @$message->admin->name }}</h5>
                                            </div>
                                            <div class="col-md-9 ps-2">
                                                <p class="text-muted fw-bold">@lang('Trimis la data')
                                                    {{ $message->created_at->format('l, dS F Y @ H:i') }}</p>
                                                <p>{{ $message->message }}</p>
                                                @if ($message->attachments->count() > 0)
                                                    <div class="mt-2">
                                                        @foreach ($message->attachments as $k => $image)
                                                            <a href="{{ route('influencer.ticket.download', encrypt($image->id)) }}"
                                                                class="text--base mr-3"><i class="fa fa-file"></i>
                                                                @lang('Attachment') {{ ++$k }} </a>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
                </div>
            </div>
        </div>
    </div>
@endsection
