@php
    $kycContent = getContent('influencer_kyc.content', true);
@endphp
@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <style>
        .day-section {
            margin-bottom: 2rem;
        }

        .interval-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }

        .toggle-btn {
            padding: 6px 10px;
            font-size: 0.8rem;
        }

        .toggle-btn.active {
            background-color: #0d6efd;
            color: white;
        }
    </style>
    @if (authInfluencer()->kv == 0)
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification required')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->verification_content) }}
                <a href="{{ route('influencer.kyc.form') }}" class="text--base">@lang('Click Here to Verify')</a>
            </p>
        </div>
    @elseif(authInfluencer()->kv == 2)
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
            <hr>
            <p class="mb-0">{{ __($kycContent->data_values->pending_content) }}
                <a href="{{ route('influencer.kyc.data') }}" class="text--base">@lang('See KYC Data')</a>
            </p>
        </div>
    @endif
    <div class="wrapper">
        <div class="preloader"></div>

        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'influencer.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <form action="{{ route('influencer.service.store', @$service->id) }}" method="POST"
                            enctype="multipart/form-data" class="create-service-form">
                            @csrf
                            <div class="row pb40">
                                <div class="col-lg-9">
                                    <div class="dashboard_title_area">
                                        <h2>Adaugă Serviciile Oferite</h2>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="text-lg-end">
                                        {{-- <a href="" class="ud-btn btn-dark">Salvează & Publică<i
                                                class="fal fa-arrow-right-long"></i></a> --}}
                                    </div>
                                </div>
                            </div>
                            <div class="ps-widget bgc-white bdrs12 p30 mb30 overflow-hidden position-relative">
                                <div class="bdrb1 pb15 mb30">
                                    <h5 class="list-title">Imagine</h5>
                                </div>
                                <div class="col-xl-9">
                                    <div class="d-flex mb30">
                                        <div class="d-flex justify-content-center">
                                            <img id="upload-img"
                                                src="@if (isset($service)) {{ getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service')) }}@else{{ getImage(getFilePath('service') . '/thumb_' . @$general->default_image, getFileThumb('service')) }} @endif"
                                                alt="userProfile" name="userProfileImg"
                                                style="max-height: 200px; max-width: 600px; object-fit: contain;">
                                            <label class="badge badge--icon badge--fill-base update-thumb-icon"
                                                for="update-photo"><i class="las la-pen"></i></label>
                                        </div>
                                        <div class="profile__info">

                                        </div>
                                    </div>
                                    <p class="text">Max file size is 1MB, Minimum dimension: 330x300 And Suitable
                                        files are .jpg & .png</p>

                                    <input type="file" name="image" class="form-control " id="update-photo"
                                        @if (!@$service) required @endif>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <div class="bdrb1 pb15 mb25">
                                            <h5 class="list-title">Informații Generale</h5>
                                        </div>


                                        <div class="col-xl-12">

                                            <div class="row">
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <label class="heading-color ff-heading fw500 mb10">Titlu
                                                            Serviciu</label>
                                                        <input type="text" class="form-control" name="title"
                                                            placeholder="ex: Consultanță în Marketing"
                                                            value="{{ @$service->title ?? '' }}">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <label class="heading-color ff-heading fw500 mb10">Preț in
                                                            Lei</label>
                                                        <input type="number" class="form-control" placeholder="ex: 100"
                                                            value="{{ @$service->price ?? '' }}" name="price" required
                                                            step="1">
                                                    </div>
                                                </div>
                                                @php
                                                    if (@$service) {
                                                        $categoryId = $service->category_id;
                                                    } else {
                                                        $categoryId = old('category_id');
                                                    }
                                                @endphp
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <div class="form-style1">
                                                            <label class="heading-color ff-heading fw500 mb10"
                                                                for="category_id">@lang('Categorie')</label>
                                                            <div class="bootselect-multiselect">
                                                                <select class="selectpicker" name="category_id"
                                                                    id="category_id" required>
                                                                    <option value="" selected disabled>
                                                                        @lang('Selectează categoria')</option>
                                                                    @foreach ($categories as $category)
                                                                        <option value="{{ $category->id }}"
                                                                            @if ($categoryId == $category->id) selected="selected" @endif>
                                                                            {{ __($category->name) }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- <div class="col-md-6 col-sm-12">
                                                    <div class="mb20">
                                                        <div class="form-style1">
                                                            <label
                                                                class="heading-color ff-heading fw500 mb10">Skill-uri</label>
                                                            <div class="bootselect-multiselect">
                                                                <select class="selectpicker" multiple="multiple"
                                                                    name="tags[]">
                                                                    @php $tags = App\Models\Tag::all(); @endphp
                                                                    @if ($tags)
                                                                        @foreach ($tags as $tag)
                                                                            <option value="{{ @$tag->name }}" @if (isset($service) && $service->tags->contains($tag->name)) selected @endif>
                                                                                {{ __($tag->name) }}</option>
                                                                        @endforeach
                                                                    @endif
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> --}}

                                                <div class="col-md-12">
                                                    <div class="mb10">
                                                        <label class="heading-color ff-heading fw500 mb10">Detalii
                                                            Servicii</label>
                                                        <textarea cols="30" rows="6" placeholder="Descriere" name="description"> @if (@$service)
{{ @$service->description }}
@endif
</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <h2 class="mb-4">Setează-ți programul pentru întâlniri</h2>
                                                    <div class="row" id="availabilityForm">
                                                        {{-- <div class="col-3">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Luni</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                   
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Marti</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                   
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Miercuri</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                   
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Joi</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                   
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Vineri</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                   
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Sambata</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Duminica</label>
                                                                <select class="form-select" name="startTime" required multiple>
                                                                    
                                                                    @for ($i = 0; $i < 24; $i++)
                                                                        @for ($j = 0; $j < 60; $j += 15)
                                                                            <option value="{{ sprintf('%02d:%02d', $i, $j) }}">
                                                                                {{ sprintf('%02d:%02d', $i, $j) }}</option>
                                                                        @endfor
                                                                    @endfor
                                                                </select>
                                                            </div>
                                                        </div> --}}
                                                        {{-- select meeting time: 15 minute , 30 minute, 45 min , o ora --}}
                                                        <div class="col-6">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Durata
                                                                    întâlnirii</label>
                                                                <select class="form-select" name="durata_sedinta"
                                                                    id="duration" required
                                                                    value="{{ @$service->durata_sedinta ?? '' }}">
                                                                    @if (isset($service))
                                                                        <option
                                                                            @if ($service->durata_sedinta == null) selected @endif>
                                                                            Selectează durata întâlnirii</option>
                                                                        <option
                                                                            @if ($service->durata_sedinta == 15) selected @endif
                                                                            value="15">15 minute</option>
                                                                        <option
                                                                            @if ($service->durata_sedinta == 30) selected @endif
                                                                            value="30">30 minute</option>
                                                                        <option
                                                                            @if ($service->durata_sedinta == 45) selected @endif
                                                                            value="45">45 minute</option>
                                                                        <option
                                                                            @if ($service->durata_sedinta == 60) selected @endif
                                                                            value="60">1 oră</option>
                                                                    @else
                                                                        <option value="0" selected>Fără întâlnire
                                                                        </option>
                                                                        <option value="15">15 minute</option>
                                                                        <option value="30">30 minute</option>
                                                                        <option value="45">45 minute</option>
                                                                        <option value="60">1 oră</option>
                                                                    @endif

                                                                </select>
                                                            </div>
                                                        </div>
                                                        {{-- select pause time intre intalniri --}}
                                                        <div class="col-6">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Pauză
                                                                    între întâlniri</label>
                                                                <select class="form-select" name="durata_pauza"
                                                                    id="pause" required disabled
                                                                    value="{{ @$service->durata_pauza ?? '' }}">
                                                                    @if (isset($service))
                                                                        <option
                                                                            @if ($service->durata_pauza == null) selected @endif>
                                                                            Selectează durata pauzei</option>
                                                                        <option
                                                                            @if ($service->durata_pauza == 15) selected @endif
                                                                            value="15">15 minute</option>
                                                                        <option
                                                                            @if ($service->durata_pauza == 30) selected @endif
                                                                            value="30">30 minute</option>
                                                                        <option
                                                                            @if ($service->durata_pauza == 45) selected @endif
                                                                            value="45">45 minute</option>
                                                                        <option
                                                                            @if ($service->durata_pauza == 60) selected @endif
                                                                            value="60">1 oră</option>
                                                                    @else
                                                                        <option value="0" selected>Fără pauză</option>
                                                                        <option value="15">15 minute</option>
                                                                        <option value="30">30 minute</option>
                                                                        <option value="45">45 minute</option>
                                                                        <option value="60">1 oră</option>
                                                                    @endif
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="scheduleContainer"></div>
                                                        <input type="hidden" name="schedule" id="schedule">
                                                    </div>


                                                    <script>
                                                        const existingSchedule = JSON.parse(@json($service->schedule ?? 'null'));

                                                        const days = ['Luni', 'Marți', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă', 'Duminică'];
                                                        const startHour = 6;
                                                        const endHour = 24;

                                                        var activeDuration = 40;



                                                        var pauseDuration = 0;

                                                        const durationSelect = document.getElementById('duration');
                                                        const pauseSelect = document.getElementById('pause');

                                                        @if (isset($service))
                                                            @if ($service->durata_sedinta != null)
                                                                activeDuration = parseInt({{ $service->durata_sedinta }});
                                                            @endif
                                                            @if ($service->durata_pauza != null)
                                                                pauseDuration = parseInt({{ $service->durata_pauza }});
                                                            @endif
                                                        @endif


                                                        var intervalDuration = activeDuration + pauseDuration;

                                                        const container = document.getElementById('scheduleContainer');

                                                        function pad(num) {
                                                            return num.toString().padStart(2, '0');
                                                        }

                                                        function formatTime(h, m) {
                                                            return `${pad(h)}:${pad(m)}`;
                                                        }

                                                        function generateIntervals() {
                                                            let intervals = [];
                                                            let h = startHour,
                                                                m = 0;
                                                            while (h < endHour || (h === endHour && m === 0)) {
                                                                let start = formatTime(h, m);
                                                                let endMins = h * 60 + m + activeDuration;
                                                                let endH = Math.floor(endMins / 60);
                                                                let endM = endMins % 60;
                                                                let end = formatTime(endH, endM);
                                                                if (endH >= 24) break;
                                                                intervals.push(`${start} - ${end}`);
                                                                m += intervalDuration;
                                                                while (m >= 60) {
                                                                    m -= 60;
                                                                    h++;
                                                                }
                                                            }
                                                            return intervals;
                                                        }

                                                        function updateSelectedIntervals() {
                                                            const selected = {};
                                                            document.querySelectorAll('.toggle-btn.active').forEach(btn => {
                                                                const day = btn.dataset.day;
                                                                const value = btn.dataset.value;
                                                                if (!selected[day]) selected[day] = [];
                                                                selected[day].push(value);
                                                            });
                                                            console.log('Program selectat:', selected);
                                                            document.getElementById('schedule').value = JSON.stringify(selected);

                                                        }


                                                        @if (isset($service))
                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        @endif




                                                        durationSelect.addEventListener('change', function() {
                                                            // Clear previous schedule
                                                            container.innerHTML = '';
                                                            // we unlock the pause select
                                                            pauseSelect.removeAttribute('disabled');
                                                            activeDuration = parseInt(this.value);
                                                            intervalDuration = activeDuration + pauseDuration;


                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        });

                                                        // pause duration
                                                        pauseSelect.addEventListener('change', function() {
                                                            // Clear previous schedule
                                                            container.innerHTML = '';
                                                            // we unlock the pause select
                                                            pauseSelect.removeAttribute('disabled');
                                                            activeDuration = parseInt(durationSelect.value);
                                                            pauseDuration = parseInt(this.value);
                                                            intervalDuration = activeDuration + pauseDuration;


                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        });
                                                    </script>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="text-start">
                                                        <button type="submit" class="ud-btn btn-thm">Posteaza<i
                                                                class="fal fa-arrow-right-long"></i></a>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
    <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            const inputField = document.querySelector('#update-photo'),
                uploadImg = document.querySelector('#upload-img');
            inputField.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        const result = reader.result;
                        uploadImg.src = result;
                    }
                    reader.readAsDataURL(file);
                }
            });


            @if (isset($images))
                let preloaded = @json($images);
            @else
                let preloaded = [];
            @endif

            $('.input-images').imageUploader({
                preloaded: preloaded,
                imagesInputName: 'images',
                preloadedInputName: 'old',
                maxSize: 2 * 1024 * 1024,
            });

            $('.pointBtn').on('click', function() {
                var html = `
                <div class="key-point d-flex gap-2 mb-3">
                    <input type="text" class="form-control form--control" name="key_points[]" required>
                    <button class="btn btn--danger remove-button border-0" type="button"><i class="fas fa-times"></i></button>
                </div>`;
                $('#more-keyPoint').append(html);
            });

            $(document).on('click', '.remove-button', function() {
                $(this).closest('.key-point').remove();
            });


            $(".select2-auto-tokenize").select2({
                tags: true,
                tokenSeparators: [","],
                dropdownParent: $(".skill-body"),
            });

        })(jQuery);
    </script>
@endpush
