@extends($activeTemplate . 'layouts.frontend2')
@section('content')


    <!-- Breadcumb Sections -->
    <section class="breadcumb-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-8 col-lg-10">
                    <div class="breadcumb-style1 mb10-xs">
                        <div class="breadcumb-list">
                            <a href="">Home</a>
                            <a href="">Services</a>
                            <a href="">Design & Creative</a>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4 col-lg-2">
                    <div class="d-flex align-items-center justify-content-sm-end">
                        <div class="share-save-widget d-flex align-items-center">
                            <span class="icon flaticon-share dark-color fz12 mr10"></span>
                            <div class="h6 mb-0">Share</div>
                        </div>
                        <div class="share-save-widget d-flex align-items-center ml15">
                            <span class="icon flaticon-like dark-color fz12 mr10"></span>
                            <div class="h6 mb-0">Save</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Breadcumb Sections -->
    <section class="breadcumb-section pt-0">
        <div
            class="cta-service-v1 freelancer-single-style mx-auto maxw1700 pt120 pt60-sm pb120 pb60-sm bdrs16 position-relative overflow-hidden d-flex align-items-center mx20-lg px30-lg">
            <img class="left-top-img wow zoomIn" src="https://infu.nibiru-it.ro/theme/images/vector-img/left-top.png"
                alt="">
            <img class="right-bottom-img wow zoomIn"
                src="https://infu.nibiru-it.ro/theme/images/vector-img/right-bottom.png" alt="">
            <div class="container">
                <div class="row wow fadeInUp">
                    <div class="col-xl-7">
                        <div class="position-relative">
                            {{-- <h2>I will design website UI UX in adobe xd or figma</h2> --}}
                            <div class="list-meta d-sm-flex align-items-center mt30">
                                <a class="position-relative freelancer-single-style" href="">
                                    <span class="online"></span>
                                    <img class="rounded-circle w-100 wa-sm mb15-sm"
                                        src="{{ getImage(getFilePath('influencerProfile') . '/' . $influencer->image, getFileSize('influencerProfile'), true) }}"
                                        style="width: 100px; height: 100px;" alt="Freelancer Photo">
                                </a>
                                <div class="ml20 ml0-xs">
                                    <h5 class="title mb-1">{{ $influencer->fullname }}</h5>
                                    <p class="mb-0">{{ $influencer->profession }}</p>
                                    <p class="mb-0 dark-color fz15 fw500 list-inline-item mb5-sm"><i
                                            class="fas fa-star vam fz10 review-color me-2"></i>
                                        {{ $influencer->rating }} ({{ getAmount($influencer->total_review) }}) reviews</p>
                                    <p class="mb-0 dark-color fz15 fw500 list-inline-item ml15 mb5-sm ml0-xs"><i
                                            class="flaticon-place vam fz20 me-2"></i> {{ $influencer->address->city }}</p>
                                    {{-- <p class="mb-0 dark-color fz15 fw500 list-inline-item ml15 mb5-sm ml0-xs"><i class="flaticon-30-days vam fz20 me-2"></i> Member since April 1, 2022</p> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Service Details -->
    <section class="pt10 pb90 pb30-md">
        <div class="container">
            <div class="row wow fadeInUp">
                <div class="col-lg-8">
                    {{-- <div class="row">
                        <div class="col-sm-6 col-xl-3">
                            <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                <div class="icon flex-shrink-0"><span class="flaticon-goal"></span></div>
                                <div class="details">
                                    <h5 class="title">Programari Totale</h5>
                                    <p class="mb-0 text">
                                        {{ $influencer->Hiring->count() }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xl-3">
                            <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                <div class="icon flex-shrink-0"><span class="flaticon-fifteen"></span></div>
                                <div class="details">
                                    <h5 class="title">Total Hours</h5>
                                    <p class="mb-0 text">
                                        {{ $influencer->Hiring->count() * 30 }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xl-3">
                            <div class="iconbox-style1 contact-style d-flex align-items-start mb30">
                                <div class="icon flex-shrink-0"><span class="flaticon-file-1"></span></div>
                                <div class="details">
                                    <h5 class="title">In Queue Service</h5>
                                    <p class="mb-0 text">
                                        {{ $influencer->Hiring->where('status', 'pending')->count() }}
                                </div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="service-about">
                        <h4>Description</h4>
                        <p class="text mb30"> {{ $influencer->summary }}</p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog-sidebar ms-lg-auto">
                        <div class="price-widget pt25 widget-mt-minus bdrs8">
                            <h3 class="widget-title">Average Cost: {{ $influencer->services->sum('price') / $influencer->services->count() * 2 }}<small>{{ $general->cur_sym }}</small><small class="fz15 fw500"> / per Ora</small></h3>
                            <div class="category-list mt20">
                                <a class="d-flex align-items-center justify-content-between bdrb1 pb-2" href="">
                                    <span class="text"><i class="flaticon-place text-thm2 pe-2 vam"></i>Locație</span>
                                    <span class="">{{ $influencer->address->city }}</span>
                                </a>
                                
                                {{-- <a class="d-flex align-items-center justify-content-between bdrb1 pb-2" href="">
                                    <span class="text"><i class="flaticon-calendar text-thm2 pe-2 vam"></i>Last Appointment</span> <span class="">2 zile</span>
                                </a> --}}
                                
                                <a class="d-flex align-items-center justify-content-between bdrb1 pb-2" href="">
                                    <span class="text"><i class="flaticon-translator text-thm2 pe-2 vam"></i>Limbi</span>
                                    @if ($influencer->languages)
                                        @foreach (@$influencer->languages as $key => $profiencies)
                                            <span class="">{{ keyToTitle($key) }} : {{ $profiency }}</span>
                                        @endforeach
                                    @endif
                                </a>
                               
                            </div>
                            <div class="d-grid">
                                <a href="{{ route('user.conversation.create', $influencer->id) }}" class="ud-btn btn-thm">Contact<i
                                        class="fal fa-arrow-right-long"></i></a>
                            </div>
                        </div>
                        @if ($influencer->skills)
                            <div class="sidebar-widget mb30 pb20 bdrs8">
                                <h4 class="widget-title">Skill-uri</h4>
                                <div class="tag-list mt30">
                                    @foreach ($influencer->skills as $skill)
                                        <li>{{ __($skill) }}</li>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('style')
    <style>
        .profile .thumb {
            width: 100px;
            height: 100px;
        }
    </style>
@endpush
