@extends($activeTemplate . 'layouts.frontend2')
@section('content')
    <style>
        .hero-home2 {
            min-height: 870px;
        }

        @media (max-width: 991.98px) {
            .hero-home2 {
                min-height: 600px;
                background: #5BBB7B;
                background: linear-gradient(180deg, rgba(91, 187, 123, 1) 0%, rgba(31, 75, 63, 1) 80%, rgba(255, 255, 255, 1) 100%);
            }

            .hero-home2 h1,
            .hero-home2 p.animate-up-2 {
                color: #fff !important;
            }

        }

        .text-black {
            color: #000 !important;
        }

        .advance-search-tab {
            border: 1px solid #000;
        }

        .home2-cta-img,
        .home6-cta-img,
        .home10-cta-img {
            top: 16%;
        }
    </style>
    <div class="body_content">
        <!-- Home Banner Style V1 -->
        <section class="hero-home2 p-0">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7">
                        <div class="pr30 pr0-lg mb30-md position-relative" style="margin-top: 0%;">
                            <h1 class="animate-up-1 mb25 ">
                                The first marketplace for 1:1 live sessions with real people and creators who teach you from
                                experience, not textbooks.
                            </h1>
                            <p class=" animate-up-2">
                                Whether you want to learn English, overcome a tough period, or change
                                your lifestyle, on Solveet you’ll find people who’ve been through
                                it—and are ready to share what truly helped them. Real. Personal. Live.
                            </p>
                            <div class="advance-search-tab col-12 col-8 p10 banner-btn position-relative zi1 animate-up-3 mt30"
                                style="border-radius: 100px!important; border: 0px solid #00000000;">
                                <div class="row">
                                    <div class="col-md-12 col-lg-12 col-xl-12 aling-items-center">
                                        <div class="advance-search-field">
                                            <form class="form-search position-relative" action="{{ route('influencers') }}"
                                                method="GET" id="searchForm">
                                                <div class="box-search">
                                                    <span class="icon far fa-magnifying-glass" onClick="searchBtn()"></span>
                                                    <input class="form-control" type="text" name="search"
                                                        placeholder="Search for an experience, a skill or a creator....">

                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="d-none">
                                        <div class="text-center h-100 text-xl-start">
                                            <button class="w-100 btn h-100" type="submit" id="searchBtn" form="searchForm">
                                                <i class="fa fs-4 fa-search"></i>
                                            </button>
                                        </div>
                                        <style>
                                            .icon.far.fa-magnifying-glass {
                                                cursor: pointer;
                                            }
                                        </style>
                                        <script>
                                            function searchBtn() {
                                                document.getElementById('searchBtn').click();
                                            }
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt20 animate-up-4">
                                {{-- <div class="col-xl-9">
                                    <div class="row justify-content-between">
                                        <div class="col-6 col-sm-3 funfact_one at-home2-hero">
                                            <div class="details">
                                                <ul class="ps-0 mb-0 d-flex">
                                                    <li>
                                                        <div class="timer">834</div>
                                                    </li>
                                                    <li><span>M</span></li>
                                                </ul>
                                                <p class="text-white mb-0">Total Freelancer</p>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 funfact_one at-home2-hero">
                                            <div class="details">
                                                <ul class="ps-0 mb-0 d-flex">
                                                    <li>
                                                        <div class="timer">732</div>
                                                    </li>
                                                    <li><span>M</span></li>
                                                </ul>
                                                <p class="text-white mb-0">Positive Review</p>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 funfact_one at-home2-hero">
                                            <div class="details">
                                                <ul class="ps-0 mb-0 d-flex">
                                                    <li>
                                                        <div class="timer">90</div>
                                                    </li>
                                                    <li><span>M</span></li>
                                                </ul>
                                                <p class="text-white mb-0">Order recieved</p>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 funfact_one at-home2-hero pe-0">
                                            <div class="details">
                                                <ul class="ps-0 mb-0 d-flex">
                                                    <li>
                                                        <div class="timer">236</div>
                                                    </li>
                                                    <li><span>M</span></li>
                                                </ul>
                                                <p class="text-white mb-0">Projects Completed</p>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5 d-none d-xl-block position-relative">
                        <img src="assets/home_nou_decupata.png" alt="image" class="animate-up-1 main-img-home2"
                            style="max-height: 650px;">
                        {{-- <div class="home2-hero-content position-relative">
                            <div
                                class="iconbox-small1 d-none d-xl-flex wow fadeInRight default-box-shadow4 bounce-x animate-up-1">
                                <span class="icon flaticon-review"></span>
                                <div class="details pl20">
                                    <h6 class="mb-1">Proof of quality</h6>
                                    <p class="text fz13 mb-0">Lorem Ipsum Dolar Amet</p>
                                </div>
                            </div>
                            <div
                                class="iconbox-small2 d-none d-xl-flex wow fadeInLeft default-box-shadow4 bounce-y animate-up-2">
                                <span class="icon flaticon-review"></span>
                                <div class="details pl20">
                                    <h6 class="mb-1">Safe and secure</h6>
                                    <p class="text fz13 mb-0">Lorem Ipsum Dolar Amet</p>
                                </div>
                            </div>
                            <img src="theme/images/about/happy-client.png" alt=""
                                class="bounce-x bdrs16 img-1 default-box-shadow4">
                        </div> --}}
                    </div>
                </div>
            </div>
        </section>


        <!-- CTA Banner -->
        {{-- 
 <section class="cta-banner-about2 before-none at-home2 position-relative py-0">
    <div class="container position-relative">
        <div class="row align-items-center">
            <div class="col-lg-7 col-xl-5 mb100-md">
                <div class="mb30">
                    <h5 class="text-thm">Descoperă experți care îți pot transforma cunoștințele și abilitățile</h5>
                    <h2 class="title">Suntem viitorul învățării și al dezvoltării personale</h2>
                </div>
                <p class="text">Fie că vrei să înveți o limbă străină, să-ți dezvolți noi abilități sau să explorezi un domeniu nou, Solveet îți oferă acces la oameni pregătiți să te ajute. Rezervă sesiuni 1:1 live și primește îndrumare personalizată, oriunde te-ai afla. Transformă-ți timpul într-o investiție reală în tine!
                </p>
                <a class="ud-btn btn-thm bdrs90 default-box-shadow2 mt15 mb30-sm"
                    href="{{ route('services') }}">Găsește un Solver<i class="fal fa-arrow-right-long"></i></a>
            </div>
        <div class="col-lg-5 col-xl-4 offset-xl-1 position-relative">
                <div class="listbox-style1 px30 py-5 bdrs16 bgc-thm2 mt30-md position-relative">
                    <div>
                        <h3 class="animate-up-1 text-white text-center">Suntem viitorul învățării și al dezvoltării
                            personale</h3>
                        <p class="text animate-up-1 text-white text-center">Solveet te conectează cu experți și
                            mentori de top, oferindu-ți sesiuni live 1:1 adaptate nevoilor tale. Fie că vrei să
                            dobândești o abilitate nouă, să îți îmbunătățești stilul de viață sau să te dezvolți
                            personal, suntem aici să te ajutăm să reușești.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <img class="home2-cta-img" src="assets/images/frontend/about/pexels-cottonbro-7600893.jpg" alt="" style="
    object-fit: cover;
    height: 480px;
    width: 28%;
    
">
</section>
        --}}
        {{-- Ultimele servicii --}}
        <section class="p-0">
            <div class="container">
                <div class="row">
                    <h2 class="title  mb-4">Recent Experiences</h2>
                    <div class="col-lg-12">
                        <div class="navpill-style2">
                            <div class="tab-content ha" id="pills-tabContent">
                                <div class="tab-pane fade fz15 text show active" id="pills-home" role="tabpanel"
                                    aria-labelledby="pills-home-tab">
                                    <div class="row">

                                        @php
                                            $servicePropular = getContent('service.content', true);
                                            $servicesPropular = App\Models\Service::approved()
                                                ->with('influencer', 'category')
                                                ->latest()
                                                ->orderBy('rating', 'desc')
                                                ->take(20)
                                                ->get();
                                        @endphp
                                        @if ($servicesPropular->count() > 0)
                                            @foreach ($servicesPropular as $service)
                                                <div class="col-sm-6 col-xl-3">
                                                    <div class="listing-style1 default-box-shadow1 bdrs16">
                                                        <div class="list-thumb">
                                                            <a
                                                                href="{{ route('service.details', [slug($service->title), $service->id]) }}">
                                                                <img class="w-100"
                                                                    src="{{ getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service')) }}"
                                                                    alt="images">
                                                            </a>
                                                        </div>
                                                        <div class="list-content">
                                                            <p class="list-text body-color fz14 mb-1">
                                                                {{-- {{ __(@$service->category->name) }}</p> --}}
                                                            <h5 class="list-title"><a
                                                                    href="{{ route('service.details', [slug($service->title), $service->id]) }}">{{ __(@$service->title) }}</a>
                                                            </h5>
                                                            <div class="review-meta d-flex align-items-center">
                                                                <i class="fas fa-star fz10 review-color me-2"></i>
                                                                <p class="mb-0 body-color fz14">
                                                                    <span
                                                                        class="dark-color me-2">{{ $service->rating }}</span>{{ $service->reviews_count ?? 0 }}
                                                                    reviews
                                                                </p>
                                                            </div>
                                                            <hr class="my-2">
                                                            <div
                                                                class="list-meta d-flex justify-content-between align-items-center mt15">
                                                                <a
                                                                    href="{{ route('influencer.profile', [slug($service->influencer->username), $service->influencer->id]) }}">
                                                                    <span class="position-relative mr10">
                                                                        <img class="rounded-circle"
                                                                            src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                                                            alt="Freelancer Photo"
                                                                            style="width: 40px; height: 40px;">
                                                                        <span class="online-badge"></span>
                                                                    </span>
                                                                    <span
                                                                        class="fz14">{{ __(@$service->influencer->username) }}</span>
                                                                </a>
                                                                <div class="budget">
                                                                    <p class="mb-0 body-color">Starting at<span
                                                                            class="fz17 fw500 dark-color ms-1">{{ showAmount($service->price) }}</span>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div class="col-lg-12">
                                                <div class="text-center">
                                                    <a class="ud-btn btn-light-thm bdrs60"
                                                        href="{{ route('services') }}">See more
                                                        <i class="fal fa-arrow-right-long"></i></a>
                                                </div>
                                            </div>
                                        @endif

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- Popular Services -->
        <section class="p-0">
            <div class="container">

                <div class="row">
                    <h2 class="title mb-4">Apprecited by others</h2>
                    <div class="col-lg-12">
                        <div class="navpill-style2">
                            <div class="tab-content ha" id="pills-tabContent">
                                <div class="tab-pane fade fz15 text show active" id="pills-home" role="tabpanel"
                                    aria-labelledby="pills-home-tab">
                                    <div class="row">

                                        @php
                                            $servicePropular = getContent('service.content', true);
                                            $servicesPropular = App\Models\Service::approved()
                                                ->with('influencer', 'category')
                                                ->latest()
                                                ->orderBy('rating', 'desc')
                                                ->take(20)
                                                ->get();
                                        @endphp
                                        @if ($servicesPropular->count() > 0)
                                            @foreach ($servicesPropular as $service)
                                                <div class="col-sm-6 col-xl-3">
                                                    <div class="listing-style1 default-box-shadow1 bdrs16">
                                                        <div class="list-thumb">
                                                            <a
                                                                href="{{ route('service.details', [slug($service->title), $service->id]) }}">
                                                                <img class="w-100"
                                                                    src="{{ getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service')) }}"
                                                                    alt="images">
                                                            </a>
                                                        </div>
                                                        <div class="list-content">
                                                            <p class="list-text body-color fz14 mb-1">
                                                                {{-- {{ __(@$service->category->name) }}</p> --}}
                                                            <h5 class="list-title"><a
                                                                    href="{{ route('service.details', [slug($service->title), $service->id]) }}">{{ __(@$service->title) }}</a>
                                                            </h5>
                                                            <div class="review-meta d-flex align-items-center">
                                                                <i class="fas fa-star fz10 review-color me-2"></i>
                                                                <p class="mb-0 body-color fz14">
                                                                    <span
                                                                        class="dark-color me-2">{{ $service->rating }}</span>{{ $service->reviews_count ?? 0 }}
                                                                    reviews
                                                                </p>
                                                            </div>
                                                            <hr class="my-2">
                                                            <div
                                                                class="list-meta d-flex justify-content-between align-items-center mt15">
                                                                <a
                                                                    href="{{ route('influencer.profile', [slug($service->influencer->username), $service->influencer->id]) }}">
                                                                    <span class="position-relative mr10">
                                                                        <img class="rounded-circle"
                                                                            src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}"
                                                                            alt="Freelancer Photo"
                                                                            style="width: 40px; height: 40px;">
                                                                        <span class="online-badge"></span>
                                                                    </span>
                                                                    <span
                                                                        class="fz14">{{ __(@$service->influencer->username) }}</span>
                                                                </a>
                                                                <div class="budget">
                                                                    <p class="mb-0 body-color">Starting at<span
                                                                            class="fz17 fw500 dark-color ms-1">{{ showAmount($service->price) }}</span>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div class="col-lg-12">
                                                <div class="text-center mt30">
                                                    <a class="ud-btn btn-light-thm bdrs60"
                                                        href="{{ route('services') }}">See more
                                                        <i class="fal fa-arrow-right-long"></i></a>
                                                </div>
                                            </div>
                                        @endif

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>



        <!-- Highest Rated Freelancers -->
        <section class="pt90 pt60-md pb130 pb60-md">
            <div class="container">
                <div class="row align-items-center wow fadeInUp">
                    <div class="col-lg-9">
                        <div class="main-title">
                            <h2 class="title">Top Solvers</h2>
                            {{-- <p class="paragraph">Lorem ipsum dolor sit amet, consectetur.</p> --}}
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="text-start text-lg-end mb-4">
                            <a class="ud-btn btn-light-thm bdrs90" href="/influencers">See more Solvers<i
                                    class="fal fa-arrow-right-long"></i></a>
                        </div>
                    </div>
                </div>
                @php
                    $influencerContent = getContent('top_influencer.content', true);
                    $influencers = App\Models\Influencer::latest()->take(20)->get();

                @endphp
                <div class="row">
                    <div class="col-lg-12">
                        <div class="navi_pagi_bottom_center slider-4-grid owl-carousel owl-theme">
                            @foreach ($influencers as $influencer)
                                <div class="item">
                                    <div class="freelancer-style1 text-center bdr1 hover-box-shadow mb60 bdrs16">
                                        <div class="thumb w90 mb25 mx-auto position-relative rounded-circle">
                                            <img class="rounded-circle mx-auto"
                                                src="{{ getImage(getFilePath('influencerProfile') . '/' . @$influencer->image, getFileSize('influencerProfile'), true) }}"
                                                alt="">
                                            {{-- <span class="online"></span> --}}
                                        </div>
                                        <div class="details">
                                            <h5 class="title mb-1">{{ __($influencer->fullname) }}</h5>
                                            <p class="mb-0">{{ __($influencer->profession) }}</p>
                                            <div class="review">
                                                <p><i class="fas fa-star fz10 review-color pr10"></i><span
                                                        class="dark-color">{{ __($influencer->rating) }}</span>
                                                    ({{ $influencer->total_review ?? 0 }} reviews)
                                                </p>
                                            </div>
                                            <div class="skill-tags d-flex align-items-center justify-content-between mb5">
                                                @if ($influencer->skills)
                                                    @foreach (@$influencer->skills as $skill)
                                                        <span class="tag">{{ __($skill) }}</span>
                                                    @endforeach
                                                @else
                                                    <span class="tag">@lang('No Specific Skill')</span>
                                                @endif
                                            </div>
                                            <hr class="opacity-100 mt20 mb15">
                                            <div class="fl-meta d-flex align-items-center justify-content-between">
                                                <a class="meta fw500 text-start">Oras<br><span
                                                        class="fz14 fw400">{{ __($influencer->address->city) }}</span></a>
                                                {{-- <a class="meta fw500 text-start">Rate<br><span class="fz14 fw400">$90 /
                                                hr</span></a> --}}
                                                {{-- <a class="meta fw500 text-start">Job Success<br><span
                                                class="fz14 fw400">%98</span></a> --}}
                                            </div>
                                            <div class="d-grid mt15">
                                                <a href="{{ route('influencer.profile', ['name' => $influencer->username, 'id' => $influencer->id]) }}"
                                                    class="ud-btn btn-light-thm bdrs90">Vezi
                                                    Profile<i class="fal fa-arrow-right-long"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- Our Testimonials -->
        <section class="our-testimonial">
            <div class="container wow fadeInUp" data-wow-delay="300ms">
                <div class="row">
                    <div class="col-lg-6 m-auto">
                        <div class="main-title text-center">
                            <h2 class="title">Feedback from real people</h2>
                            <p class="paragraph mt10">Fiecare Solver a început de undeva - fii tu primul care oferă
                                feedback și ajută comunitatea Solveet să crească prin recenzii sincere...</p>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-10 mx-auto">
                        <div class="home2_testimonial_tabs position-relative">
                            <div class="tab-content" id="pills-tabContent2">
                                <div class="tab-pane fade show active" id="pills-profile" role="tabpanel"
                                    aria-labelledby="pills-profile-tab">
                                    <div class="testimonial-style2 at-about2 text-center">
                                        <div class="testi-content text-center">
                                            <span class="icon fas fa-quote-left"></span>
                                            <h4 class="testi-text">"Our family was traveling via bullet train between
                                                cities in Japan with our luggage - the location for this hotel made that so
                                                easy. Agoda price was fantastic. "</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <ul class="nav justify-content-center" id="pills-tab2" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="pills-home-tab" data-bs-toggle="pill" href="#pills-home"
                                        role="tab" aria-controls="pills-home" aria-selected="true">
                                        <div class="thumb d-flex align-items-center">
                                            <img class="rounded-circle" src="theme/images/testimonials/1.jpg"
                                                alt="1.jpg">
                                            <h6 class="title ml30 ml15-xl mb-0">Albert Cole<br><small>Designer</small></h6>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- Need something -->
        <section class="our-features pb90 pb30-md pt60 d-none d-md-block">
            <div class="container wow fadeInUp">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-title">
                            <h2>Want to learn from someone who’s actually did it?</h2>
                            <p class="text">
                                On Solveet, you’re not looking for mentors. You’ll find real
                                people—just like you—who’ve already been through what you’re facing.
                                No fancy degrees, no filters. Just raw, 1:1 experience.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 col-lg-3">
                        <div class="iconbox-style1 at-home5 p-0">
                            <div class="icon before-none"><span class="flaticon-cv"></span></div>
                            <div class="details">
                                <h4 class="title mt10 mb-3"> Global Access → Real people like you, from all over the world
                                </h4>
                                <p class="text">
                                    Connect with authentic creators eager to share what they’ve lived and
                                    what really worked for them.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="iconbox-style1 at-home5 p-0">
                            <div class="icon before-none"><span class="flaticon-web-design"></span></div>
                            <div class="details">
                                <h4 class="title mt10 mb-3">No Mentors → Just human validation</h4>
                                <p class="text">
                                    We don’t have “certified experts.” We have people who speak from real,
                                    lived experience. You choose who fits your vibe.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="iconbox-style1 at-home5 p-0">
                            <div class="icon before-none"><span class="flaticon-secure"></span></div>
                            <div class="details">
                                <h4 class="title mt10 mb-3">
                                    Simple Payments → Clear, hassle-free, 1:1 meetings
                                </h4>
                                <p class="text">
                                    Book, pay, and talk directly with your chosen creator. Our platform just connects you.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <div class="iconbox-style1 at-home5 p-0">
                            <div class="icon before-none"><span class="flaticon-customer-service"></span></div>
                            <div class="details">
                                <h4 class="title mt10 mb-3">
                                    Quality Guarantee → Don’t like the first session? Don’t pay.
                                </h4>
                                <p class="text">You’re free to change your mind. If the first chat doesn’t help, we’ll
                                    refund you. No stress, just real conversations. T&C applied.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
