<?php

namespace App\Http\Controllers\Influencer\Auth;

use App\Models\GeneralSetting;
use App\Http\Controllers\Controller;
use App\Models\Influencer;
use App\Models\InfluencerPasswordReset;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Illuminate\Validation\Rules\Password;

class ResetPasswordController extends Controller
{
     /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;


    public function __construct()
    {
        $this->middleware('influencer.guest');
        $this->activeTemplate = activeTemplate();
    }

    public function showResetForm(Request $request, $token = null)
    {

        $email = session('fpass_email');
        $token = session()->has('token') ? session('token') : $token;
        if (InfluencerPasswordReset::where('token', $token)->where('email', $email)->count() != 1) {
            $notify[] = ['error', 'Invalid token'];
            return to_route('influencer.password.request')->withNotify($notify);
        }
        return view($this->activeTemplate . 'influencer.auth.passwords.reset')->with(
            ['token' => $token, 'email' => $email, 'pageTitle' => 'Reset Password']
        );
    }

    public function reset(Request $request)
    {

        session()->put('fpass_email', $request->email);
        $request->validate($this->rules(), $this->validationErrorMessages());
        $reset = InfluencerPasswordReset::where('token', $request->token)->orderBy('created_at', 'desc')->first();
        if (!$reset) {
            $notify[] = ['error', 'Invalid verification code'];
            return to_route('influencer.login')->withNotify($notify);
        }

        $influencer = Influencer::where('email', $reset->email)->first();
        $influencer->password = bcrypt($request->password);
        $influencer->save();



        $influencerIpInfo = getIpInfo();
        $influencerBrowser = osBrowser();
        notify($influencer, 'PASS_RESET_DONE', [
            'operating_system' => @$influencerBrowser['os_platform'],
            'browser' => @$influencerBrowser['browser'],
            'ip' => @$influencerIpInfo['ip'],
            'time' => @$influencerIpInfo['time']
        ],['email']);


        $notify[] = ['success', 'Password changed successfully'];
        return to_route('influencer.login')->withNotify($notify);
    }

    /**
     * Get the password reset validation rules.
     *
     * @return array
     */
    protected function rules()
    {
        $passwordValidation = Password::min(6);
        $general = gs();
        if ($general->secure_password) {
            $passwordValidation = $passwordValidation->mixedCase()->numbers()->symbols()->uncompromised();
        }
        return [
            'token' => 'required',
            'email' => 'required|email',
            'password' => ['required','confirmed',$passwordValidation],
        ];
    }
}
