<?php

namespace App\Http\Controllers\Influencer\Auth;

use App\Http\Controllers\Controller;
use App\Models\GeneralSetting;
use App\Models\Influencer;
use App\Models\UserLogin;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login / registration.
     *
     * @var string
     */
    public $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('influencer.guest')->except('logout');
        $this->username = $this->username();
        $this->activeTemplate = activeTemplate();
    }

    /**
     * Show the application's login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        $pageTitle = "Login";
        return view($this->activeTemplate.'influencer.auth.login', compact('pageTitle'));
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return auth()->guard('influencer');
    }

    public function username()
    {
        return 'username';
    }

    public function login(Request $request)
    {

        $this->validateLogin($request);

        $request->session()->regenerateToken();

        if(!verifyCaptcha()){
            $notify[] = ['error','Invalid captcha provided'];
            return back()->withNotify($notify);
        }

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    // switch from the client account to the influencer account
    public function switchAccount(Request $request)
    {   
       
        $user = auth()->user();
        // dd($user->isInfluencer);

        if ($user->isInfluencer) {
            // dd($user);
            // if the user has an influencer account, switch to it
            // we get the user's influencer account and we save them, then we log them out as client and log them in as influencer
            $influencer = $user->influencer;
            if ($influencer) {
                auth()->logout();
                auth()->guard('influencer')->login($influencer);
                $request->session()->regenerate();
                // dd($influencer);
                return redirect()->route('home');
            } else {
                return redirect()->route('home')->withErrors(['error' => 'No influencer account found']);
            }
        }
       
    }



    public function becomeInfluencerSubmit()
    {
        $user = auth()->user();
        if ($user->isInfluencer) {
            return redirect()->route('home');
        }
        
        $influencer = new Influencer();
        $influencer->firstname = $user->firstname;
        $influencer->lastname = $user->lastname;
        $influencer->username = $user->username;
        $influencer->email = $user->email;
        $influencer->country_code = $user->country_code;
        $influencer->mobile = $user->mobile;
        $influencer->ref_by = $user->ref_by;
        $influencer->balance = $user->balance;
        $influencer->password = $user->password;
        $influencer->image = $user->image;
        $influencer->address = $user->address;
        $influencer->status = 1;
        $influencer->kyc_data = $user->kyc_data;
        $influencer->kv = $user->kv;
        $influencer->ev = $user->ev;
        $influencer->sv = $user->sv;
        $influencer->reg_step = $user->reg_step;
        $influencer->ver_code = $user->ver_code;
        $influencer->ver_code_send_at = $user->ver_code_send_at;
        $influencer->ts = $user->ts;
        $influencer->tv = $user->tv;
        $influencer->tsc = $user->tsc;
        $influencer->ban_reason = $user->ban_reason;
        $influencer->remember_token = $user->remember_token;
        $influencer->last_seen = $user->user_last_seen;
        $influencer->completed_order = 0;
        $influencer->rating = 0.00;
        $influencer->total_review = 0;
        $influencer->save();


        

        return redirect()->route('influencer.switch')->with('success', 'You are now an influencer');
    }

    public function logout(Request $request)
    {
        $this->guard('influencer')->logout();
        // we also logout the user from the client account
        $user = auth()->user();
        if ($user) {
            auth()->logout();
        }
        $request->session()->invalidate();
        return $this->loggedOut($request) ?: to_route('home');
    }

    public function resetPassword()
    {
        $pageTitle = 'Account Recovery';
        return view('influencer.reset', compact('pageTitle'));
    }


    public function authenticated(Request $request, $user)
    {
        $user->tv = $user->ts == 1 ? 0 : 1;
        $user->save();
        $ip = getRealIP();
        $exist = UserLogin::where('user_ip',$ip)->first();
        $userLogin = new UserLogin();
        if ($exist) {
            $userLogin->longitude =  $exist->longitude;
            $userLogin->latitude =  $exist->latitude;
            $userLogin->city =  $exist->city;
            $userLogin->country_code = $exist->country_code;
            $userLogin->country =  $exist->country;
        }else{
            $info = json_decode(json_encode(getIpInfo()), true);
            $userLogin->longitude =  @implode(',',$info['long']);
            $userLogin->latitude =  @implode(',',$info['lat']);
            $userLogin->city =  @implode(',',$info['city']);
            $userLogin->country_code = @implode(',',$info['code']);
            $userLogin->country =  @implode(',', $info['country']);
        }

        $userAgent = osBrowser();
        $userLogin->user_id = $user->id;
        $userLogin->user_ip =  $ip;

        $userLogin->browser = @$userAgent['browser'];
        $userLogin->os = @$userAgent['os_platform'];
        $userLogin->save();


        return to_route('home');
    }
}
