var style=({dt:n})=>`\n.p-tabs {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-tablist {\n    display: flex;\n    position: relative;\n}\n\n.p-tabs-scrollable > .p-tablist {\n    overflow: hidden;\n}\n\n.p-tablist-viewport {\n    overflow-x: auto;\n    overflow-y: hidden;\n    scroll-behavior: smooth;\n    scrollbar-width: none;\n    overscroll-behavior: contain auto;\n}\n\n.p-tablist-viewport::-webkit-scrollbar {\n    display: none;\n}\n\n.p-tablist-tab-list {\n    position: relative;\n    display: flex;\n    background: ${n("tabs.tablist.background")};\n    border-style: solid;\n    border-color: ${n("tabs.tablist.border.color")};\n    border-width: ${n("tabs.tablist.border.width")};\n}\n\n.p-tablist-content {\n    flex-grow: 1;\n}\n\n.p-tablist-nav-button {\n    all: unset;\n    position: absolute !important;\n    flex-shrink: 0;\n    inset-block-start: 0;\n    z-index: 2;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background: ${n("tabs.nav.button.background")};\n    color: ${n("tabs.nav.button.color")};\n    width: ${n("tabs.nav.button.width")};\n    transition: color ${n("tabs.transition.duration")}, outline-color ${n("tabs.transition.duration")}, box-shadow ${n("tabs.transition.duration")};\n    box-shadow: ${n("tabs.nav.button.shadow")};\n    outline-color: transparent;\n    cursor: pointer;\n}\n\n.p-tablist-nav-button:focus-visible {\n    z-index: 1;\n    box-shadow: ${n("tabs.nav.button.focus.ring.shadow")};\n    outline: ${n("tabs.nav.button.focus.ring.width")} ${n("tabs.nav.button.focus.ring.style")} ${n("tabs.nav.button.focus.ring.color")};\n    outline-offset: ${n("tabs.nav.button.focus.ring.offset")};\n}\n\n.p-tablist-nav-button:hover {\n    color: ${n("tabs.nav.button.hover.color")};\n}\n\n.p-tablist-prev-button {\n    inset-inline-start: 0;\n}\n\n.p-tablist-next-button {\n    inset-inline-end: 0;\n}\n\n.p-tablist-prev-button:dir(rtl),\n.p-tablist-next-button:dir(rtl) {\n    transform: rotate(180deg);\n}\n\n.p-tab {\n    flex-shrink: 0;\n    cursor: pointer;\n    user-select: none;\n    position: relative;\n    border-style: solid;\n    white-space: nowrap;\n    gap: ${n("tabs.tab.gap")};\n    background: ${n("tabs.tab.background")};\n    border-width: ${n("tabs.tab.border.width")};\n    border-color: ${n("tabs.tab.border.color")};\n    color: ${n("tabs.tab.color")};\n    padding: ${n("tabs.tab.padding")};\n    font-weight: ${n("tabs.tab.font.weight")};\n    transition: background ${n("tabs.transition.duration")}, border-color ${n("tabs.transition.duration")}, color ${n("tabs.transition.duration")}, outline-color ${n("tabs.transition.duration")}, box-shadow ${n("tabs.transition.duration")};\n    margin: ${n("tabs.tab.margin")};\n    outline-color: transparent;\n}\n\n.p-tab:not(.p-disabled):focus-visible {\n    z-index: 1;\n    box-shadow: ${n("tabs.tab.focus.ring.shadow")};\n    outline: ${n("tabs.tab.focus.ring.width")} ${n("tabs.tab.focus.ring.style")} ${n("tabs.tab.focus.ring.color")};\n    outline-offset: ${n("tabs.tab.focus.ring.offset")};\n}\n\n.p-tab:not(.p-tab-active):not(.p-disabled):hover {\n    background: ${n("tabs.tab.hover.background")};\n    border-color: ${n("tabs.tab.hover.border.color")};\n    color: ${n("tabs.tab.hover.color")};\n}\n\n.p-tab-active {\n    background: ${n("tabs.tab.active.background")};\n    border-color: ${n("tabs.tab.active.border.color")};\n    color: ${n("tabs.tab.active.color")};\n}\n\n.p-tabpanels {\n    background: ${n("tabs.tabpanel.background")};\n    color: ${n("tabs.tabpanel.color")};\n    padding: ${n("tabs.tabpanel.padding")};\n    outline: 0 none;\n}\n\n.p-tabpanel:focus-visible {\n    box-shadow: ${n("tabs.tabpanel.focus.ring.shadow")};\n    outline: ${n("tabs.tabpanel.focus.ring.width")} ${n("tabs.tabpanel.focus.ring.style")} ${n("tabs.tabpanel.focus.ring.color")};\n    outline-offset: ${n("tabs.tabpanel.focus.ring.offset")};\n}\n\n.p-tablist-active-bar {\n    z-index: 1;\n    display: block;\n    position: absolute;\n    inset-block-end: ${n("tabs.active.bar.bottom")};\n    height: ${n("tabs.active.bar.height")};\n    background: ${n("tabs.active.bar.background")};\n    transition: 250ms cubic-bezier(0.35, 0, 0.25, 1);\n}\n`;export{style};//# sourceMappingURL=index.mjs.map