var style=({dt:e})=>`\n.p-steplist {\n    position: relative;\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    overflow-x: auto;\n}\n\n.p-step {\n    position: relative;\n    display: flex;\n    flex: 1 1 auto;\n    align-items: center;\n    gap: ${e("stepper.step.gap")};\n    padding: ${e("stepper.step.padding")};\n}\n\n.p-step:last-of-type {\n    flex: initial;\n}\n\n.p-step-header {\n    border: 0 none;\n    display: inline-flex;\n    align-items: center;\n    text-decoration: none;\n    cursor: pointer;\n    transition: background ${e("stepper.transition.duration")}, color ${e("stepper.transition.duration")}, border-color ${e("stepper.transition.duration")}, outline-color ${e("stepper.transition.duration")}, box-shadow ${e("stepper.transition.duration")};\n    border-radius: ${e("stepper.step.header.border.radius")};\n    outline-color: transparent;\n    background: transparent;\n    padding: ${e("stepper.step.header.padding")};\n    gap: ${e("stepper.step.header.gap")};\n}\n\n.p-step-header:focus-visible {\n    box-shadow: ${e("stepper.step.header.focus.ring.shadow")};\n    outline: ${e("stepper.step.header.focus.ring.width")} ${e("stepper.step.header.focus.ring.style")} ${e("stepper.step.header.focus.ring.color")};\n    outline-offset: ${e("stepper.step.header.focus.ring.offset")};\n}\n\n.p-stepper.p-stepper-readonly .p-step {\n    cursor: auto;\n}\n\n.p-step-title {\n    display: block;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    max-width: 100%;\n    color: ${e("stepper.step.title.color")};\n    font-weight: ${e("stepper.step.title.font.weight")};\n    transition: background ${e("stepper.transition.duration")}, color ${e("stepper.transition.duration")}, border-color ${e("stepper.transition.duration")}, box-shadow ${e("stepper.transition.duration")}, outline-color ${e("stepper.transition.duration")};\n}\n\n.p-step-number {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    color: ${e("stepper.step.number.color")};\n    border: 2px solid ${e("stepper.step.number.border.color")};\n    background: ${e("stepper.step.number.background")};\n    min-width: ${e("stepper.step.number.size")};\n    height: ${e("stepper.step.number.size")};\n    line-height: ${e("stepper.step.number.size")};\n    font-size: ${e("stepper.step.number.font.size")};\n    z-index: 1;\n    border-radius: ${e("stepper.step.number.border.radius")};\n    position: relative;\n    font-weight: ${e("stepper.step.number.font.weight")};\n}\n\n.p-step-number::after {\n    content: " ";\n    position: absolute;\n    width: 100%;\n    height: 100%;\n    border-radius: ${e("stepper.step.number.border.radius")};\n    box-shadow: ${e("stepper.step.number.shadow")};\n}\n\n.p-step-active .p-step-header {\n    cursor: default;\n}\n\n.p-step-active .p-step-number {\n    background: ${e("stepper.step.number.active.background")};\n    border-color: ${e("stepper.step.number.active.border.color")};\n    color: ${e("stepper.step.number.active.color")};\n}\n\n.p-step-active .p-step-title {\n    color: ${e("stepper.step.title.active.color")};\n}\n\n.p-step:not(.p-disabled):focus-visible {\n    outline: ${e("focus.ring.width")} ${e("focus.ring.style")} ${e("focus.ring.color")};\n    outline-offset: ${e("focus.ring.offset")};\n}\n\n.p-step:has(~ .p-step-active) .p-stepper-separator {\n    background: ${e("stepper.separator.active.background")};\n}\n\n.p-stepper-separator {\n    flex: 1 1 0;\n    background: ${e("stepper.separator.background")};\n    width: 100%;\n    height: ${e("stepper.separator.size")};\n    transition: background ${e("stepper.transition.duration")}, color ${e("stepper.transition.duration")}, border-color ${e("stepper.transition.duration")}, box-shadow ${e("stepper.transition.duration")}, outline-color ${e("stepper.transition.duration")};\n}\n\n.p-steppanels {\n    padding: ${e("stepper.steppanels.padding")};\n}\n\n.p-steppanel {\n    background: ${e("stepper.steppanel.background")};\n    color: ${e("stepper.steppanel.color")};\n}\n\n.p-stepper:has(.p-stepitem) {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-stepitem {\n    display: flex;\n    flex-direction: column;\n    flex: initial;\n}\n\n.p-stepitem.p-stepitem-active {\n    flex: 1 1 auto;\n}\n\n.p-stepitem .p-step {\n    flex: initial;\n}\n\n.p-stepitem .p-steppanel-content {\n    width: 100%;\n    padding: ${e("stepper.steppanel.padding")};\n    margin-inline-start: 1rem;\n}\n\n.p-stepitem .p-steppanel {\n    display: flex;\n    flex: 1 1 auto;\n}\n\n.p-stepitem .p-stepper-separator {\n    flex: 0 0 auto;\n    width: ${e("stepper.separator.size")};\n    height: auto;\n    margin: ${e("stepper.separator.margin")};\n    position: relative;\n    left: calc(-1 * ${e("stepper.separator.size")});\n}\n\n.p-stepitem .p-stepper-separator:dir(rtl) {\n    left: calc(-9 * ${e("stepper.separator.size")});\n}\n\n.p-stepitem:has(~ .p-stepitem-active) .p-stepper-separator {\n    background: ${e("stepper.separator.active.background")};\n}\n\n.p-stepitem:last-of-type .p-steppanel {\n    padding-inline-start: ${e("stepper.step.number.size")};\n}\n`;export{style};//# sourceMappingURL=index.mjs.map