var style=({dt:n})=>`\n.p-slider {\n    position: relative;\n    background: ${n("slider.track.background")};\n    border-radius: ${n("slider.track.border.radius")};\n}\n\n.p-slider-handle {\n    cursor: grab;\n    touch-action: none;\n    user-select: none;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: ${n("slider.handle.height")};\n    width: ${n("slider.handle.width")};\n    background: ${n("slider.handle.background")};\n    border-radius: ${n("slider.handle.border.radius")};\n    transition: background ${n("slider.transition.duration")}, color ${n("slider.transition.duration")}, border-color ${n("slider.transition.duration")}, box-shadow ${n("slider.transition.duration")}, outline-color ${n("slider.transition.duration")};\n    outline-color: transparent;\n}\n\n.p-slider-handle::before {\n    content: "";\n    width: ${n("slider.handle.content.width")};\n    height: ${n("slider.handle.content.height")};\n    display: block;\n    background: ${n("slider.handle.content.background")};\n    border-radius: ${n("slider.handle.content.border.radius")};\n    box-shadow: ${n("slider.handle.content.shadow")};\n    transition: background ${n("slider.transition.duration")};\n}\n\n.p-slider:not(.p-disabled) .p-slider-handle:hover {\n    background: ${n("slider.handle.hover.background")};\n}\n\n.p-slider:not(.p-disabled) .p-slider-handle:hover::before {\n    background: ${n("slider.handle.content.hover.background")};\n}\n\n.p-slider-handle:focus-visible {\n    box-shadow: ${n("slider.handle.focus.ring.shadow")};\n    outline: ${n("slider.handle.focus.ring.width")} ${n("slider.handle.focus.ring.style")} ${n("slider.handle.focus.ring.color")};\n    outline-offset: ${n("slider.handle.focus.ring.offset")};\n}\n\n.p-slider-range {\n    display: block;\n    background: ${n("slider.range.background")};\n    border-radius: ${n("slider.track.border.radius")};\n}\n\n.p-slider.p-slider-horizontal {\n    height: ${n("slider.track.size")};\n}\n\n.p-slider-horizontal .p-slider-range {\n    inset-block-start: 0;\n    inset-inline-start: 0;\n    height: 100%;\n}\n\n.p-slider-horizontal .p-slider-handle {\n    inset-block-start: 50%;\n    margin-block-start: calc(-1 * calc(${n("slider.handle.height")} / 2));\n    margin-inline-start: calc(-1 * calc(${n("slider.handle.width")} / 2));\n}\n\n.p-slider-vertical {\n    min-height: 100px;\n    width: ${n("slider.track.size")};\n}\n\n.p-slider-vertical .p-slider-handle {\n    inset-inline-start: 50%;\n    margin-inline-start: calc(-1 * calc(${n("slider.handle.width")} / 2));\n    margin-block-end: calc(-1 * calc(${n("slider.handle.height")} / 2));\n}\n\n.p-slider-vertical .p-slider-range {\n    inset-block-end: 0;\n    inset-inline-start: 0;\n    width: 100%;\n}\n`;export{style};//# sourceMappingURL=index.mjs.map