var style=({dt:n})=>`\n.p-galleria {\n    overflow: hidden;\n    border-style: solid;\n    border-width: ${n("galleria.border.width")};\n    border-color: ${n("galleria.border.color")};\n    border-radius: ${n("galleria.border.radius")};\n}\n\n.p-galleria-content {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-galleria-items-container {\n    display: flex;\n    flex-direction: column;\n    position: relative;\n}\n\n.p-galleria-items {\n    position: relative;\n    display: flex;\n    height: 100%;\n}\n\n.p-galleria-nav-button {\n    position: absolute !important;\n    top: 50%;\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n    background: ${n("galleria.nav.button.background")};\n    color: ${n("galleria.nav.button.color")};\n    width: ${n("galleria.nav.button.size")};\n    height: ${n("galleria.nav.button.size")};\n    transition: background ${n("galleria.transition.duration")}, color ${n("galleria.transition.duration")}, outline-color ${n("galleria.transition.duration")}, box-shadow ${n("galleria.transition.duration")};\n    margin: calc(-1 * calc(${n("galleria.nav.button.size")}) / 2) ${n("galleria.nav.button.gutter")} 0 ${n("galleria.nav.button.gutter")};\n    padding: 0;\n    user-select: none;\n    border: 0 none;\n    cursor: pointer;\n    outline-color: transparent;\n}\n\n.p-galleria-nav-button:not(.p-disabled):hover {\n    background: ${n("galleria.nav.button.hover.background")};\n    color: ${n("galleria.nav.button.hover.color")};\n}\n\n.p-galleria-nav-button:not(.p-disabled):focus-visible {\n    box-shadow: ${n("galleria.nav.button.focus.ring.shadow")};\n    outline: ${n("galleria.nav.button.focus.ring.width")} ${n("galleria.nav.button.focus.ring.style")} ${n("galleria.nav.button.focus.ring.color")};\n    outline-offset: ${n("galleria.nav.button.focus.ring.offset")};\n}\n\n.p-galleria-next-icon,\n.p-galleria-prev-icon {\n    font-size: ${n("galleria.nav.icon.size")};\n    width: ${n("galleria.nav.icon.size")};\n    height: ${n("galleria.nav.icon.size")};\n}\n\n.p-galleria-prev-button {\n    border-radius: ${n("galleria.nav.button.prev.border.radius")};\n    left: 0;\n}\n\n.p-galleria-next-button {\n    border-radius: ${n("galleria.nav.button.next.border.radius")};\n    right: 0;\n}\n\n.p-galleria-prev-button:dir(rtl) {\n    left: auto;\n    right: 0;\n    transform: rotate(180deg);\n}\n\n.p-galleria-next-button:dir(rtl) {\n    right: auto;\n    left: 0;\n    transform: rotate(180deg);\n}\n\n.p-galleria-item {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: 100%;\n    width: 100%;\n}\n\n.p-galleria-hover-navigators .p-galleria-nav-button {\n    pointer-events: none;\n    opacity: 0;\n    transition: opacity ${n("galleria.transition.duration")} ease-in-out;\n}\n\n.p-galleria-hover-navigators .p-galleria-items-container:hover .p-galleria-nav-button {\n    pointer-events: all;\n    opacity: 1;\n}\n\n.p-galleria-hover-navigators .p-galleria-items-container:hover .p-galleria-nav-button.p-disabled {\n    pointer-events: none;\n}\n\n.p-galleria-caption {\n    position: absolute;\n    bottom: 0;\n    left: 0;\n    width: 100%;\n    background: ${n("galleria.caption.background")};\n    color: ${n("galleria.caption.color")};\n    padding: ${n("galleria.caption.padding")};\n}\n\n.p-galleria-thumbnails {\n    display: flex;\n    flex-direction: column;\n    overflow: auto;\n    flex-shrink: 0;\n}\n\n.p-galleria-thumbnail-nav-button {\n    align-self: center;\n    flex: 0 0 auto;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n    position: relative;\n    margin: 0 ${n("galleria.thumbnail.nav.button.gutter")};\n    padding: 0;\n    border: none;\n    user-select: none;\n    cursor: pointer;\n    background: transparent;\n    color: ${n("galleria.thumbnail.nav.button.color")};\n    width: ${n("galleria.thumbnail.nav.button.size")};\n    height: ${n("galleria.thumbnail.nav.button.size")};\n    transition: background ${n("galleria.transition.duration")}, color ${n("galleria.transition.duration")}, outline-color ${n("galleria.transition.duration")};\n    outline-color: transparent;\n    border-radius: ${n("galleria.thumbnail.nav.button.border.radius")};\n}\n\n.p-galleria-thumbnail-nav-button:hover {\n    background: ${n("galleria.thumbnail.nav.button.hover.background")};\n    color: ${n("galleria.thumbnail.nav.button.hover.color")};\n}\n\n.p-galleria-thumbnail-nav-button:focus-visible {\n    box-shadow: ${n("galleria.thumbnail.nav.button.focus.ring.shadow")};\n    outline: ${n("galleria.thumbnail.nav.button.focus.ring.width")} ${n("galleria.thumbnail.nav.button.focus.ring.style")} ${n("galleria.thumbnail.nav.button.focus.ring.color")};\n    outline-offset: ${n("galleria.thumbnail.nav.button.focus.ring.offset")};\n}\n\n.p-galleria-thumbnail-nav-button .p-galleria-thumbnail-next-icon,\n.p-galleria-thumbnail-nav-button .p-galleria-thumbnail-prev-icon {\n    font-size: ${n("galleria.thumbnail.nav.button.icon.size")};\n    width: ${n("galleria.thumbnail.nav.button.icon.size")};\n    height: ${n("galleria.thumbnail.nav.button.icon.size")};\n}\n\n.p-galleria-thumbnails-content {\n    display: flex;\n    flex-direction: row;\n    background: ${n("galleria.thumbnails.content.background")};\n    padding: ${n("galleria.thumbnails.content.padding")};\n}\n\n.p-galleria-thumbnails-viewport {\n    overflow: hidden;\n    width: 100%;\n}\n\n.p-galleria:not(.p-galleria-thumbnails-right):not(.p-galleria-thumbnails-left) .p-galleria-thumbnail-prev-button:dir(rtl),\n.p-galleria:not(.p-galleria-thumbnails-right):not(.p-galleria-thumbnails-left) .p-galleria-thumbnail-next-button:dir(rtl) {\n    transform: rotate(180deg);\n}\n\n.p-galleria-thumbnail-items {\n    display: flex;\n}\n\n.p-galleria-thumbnail-item {\n    overflow: auto;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    opacity: 0.5;\n}\n\n.p-galleria-thumbnail {\n    outline-color: transparent;\n}\n\n.p-galleria-thumbnail-item:hover {\n    opacity: 1;\n    transition: opacity 0.3s;\n}\n\n.p-galleria-thumbnail-item-current {\n    opacity: 1;\n}\n\n.p-galleria-thumbnails-left .p-galleria-content,\n.p-galleria-thumbnails-right .p-galleria-content {\n    flex-direction: row;\n}\n\n.p-galleria-thumbnails-left .p-galleria-items-container,\n.p-galleria-thumbnails-right .p-galleria-items-container {\n    flex-direction: row;\n}\n\n.p-galleria-thumbnails-left .p-galleria-items-container,\n.p-galleria-thumbnails-top .p-galleria-items-container {\n    order: 2;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnails,\n.p-galleria-thumbnails-top .p-galleria-thumbnails {\n    order: 1;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnails-content,\n.p-galleria-thumbnails-right .p-galleria-thumbnails-content {\n    flex-direction: column;\n    flex-grow: 1;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnail-items,\n.p-galleria-thumbnails-right .p-galleria-thumbnail-items {\n    flex-direction: column;\n    height: 100%;\n}\n\n.p-galleria-indicator-list {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    padding: ${n("galleria.indicator.list.padding")};\n    gap: ${n("galleria.indicator.list.gap")};\n    margin: 0;\n    list-style: none;\n}\n\n.p-galleria-indicator-button {\n    display: inline-flex;\n    align-items: center;\n    background: ${n("galleria.indicator.button.background")};\n    width: ${n("galleria.indicator.button.width")};\n    height: ${n("galleria.indicator.button.height")};\n    transition: background ${n("galleria.transition.duration")}, color ${n("galleria.transition.duration")}, outline-color ${n("galleria.transition.duration")}, box-shadow ${n("galleria.transition.duration")};\n    outline-color: transparent;\n    border-radius: ${n("galleria.indicator.button.border.radius")};\n    margin: 0;\n    padding: 0;\n    border: none;\n    user-select: none;\n    cursor: pointer;\n}\n\n.p-galleria-indicator-button:hover {\n    background: ${n("galleria.indicator.button.hover.background")};\n}\n\n.p-galleria-indicator-button:focus-visible {\n    box-shadow: ${n("galleria.indicator.button.focus.ring.shadow")};\n    outline: ${n("galleria.indicator.button.focus.ring.width")} ${n("galleria.indicator.button.focus.ring.style")} ${n("galleria.indicator.button.focus.ring.color")};\n    outline-offset: ${n("galleria.indicator.button.focus.ring.offset")};\n}\n\n.p-galleria-indicator-active .p-galleria-indicator-button {\n    background: ${n("galleria.indicator.button.active.background")};\n}\n\n.p-galleria-indicators-left .p-galleria-items-container,\n.p-galleria-indicators-right .p-galleria-items-container {\n    flex-direction: row;\n    align-items: center;\n}\n\n.p-galleria-indicators-left .p-galleria-items,\n.p-galleria-indicators-top .p-galleria-items {\n    order: 2;\n}\n\n.p-galleria-indicators-left .p-galleria-indicator-list,\n.p-galleria-indicators-top .p-galleria-indicator-list {\n    order: 1;\n}\n\n.p-galleria-indicators-left .p-galleria-indicator-list,\n.p-galleria-indicators-right .p-galleria-indicator-list {\n    flex-direction: column;\n}\n\n.p-galleria-inset-indicators .p-galleria-indicator-list {\n    position: absolute;\n    display: flex;\n    z-index: 1;\n    background: ${n("galleria.inset.indicator.list.background")};\n}\n\n.p-galleria-inset-indicators .p-galleria-indicator-button {\n    background: ${n("galleria.inset.indicator.button.background")};\n}\n\n.p-galleria-inset-indicators .p-galleria-indicator-button:hover {\n    background: ${n("galleria.inset.indicator.button.hover.background")};\n}\n\n.p-galleria-inset-indicators .p-galleria-indicator-active .p-galleria-indicator-button {\n    background: ${n("galleria.inset.indicator.button.active.background")};\n}\n\n.p-galleria-inset-indicators.p-galleria-indicators-top .p-galleria-indicator-list {\n    top: 0;\n    left: 0;\n    width: 100%;\n    align-items: flex-start;\n}\n\n.p-galleria-inset-indicators.p-galleria-indicators-right .p-galleria-indicator-list {\n    right: 0;\n    top: 0;\n    height: 100%;\n    align-items: flex-end;\n}\n\n.p-galleria-inset-indicators.p-galleria-indicators-bottom .p-galleria-indicator-list {\n    bottom: 0;\n    left: 0;\n    width: 100%;\n    align-items: flex-end;\n}\n\n.p-galleria-inset-indicators.p-galleria-indicators-left .p-galleria-indicator-list {\n    left: 0;\n    top: 0;\n    height: 100%;\n    align-items: flex-start;\n}\n\n.p-galleria-mask {\n    position: fixed;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-galleria-close-button {\n    position: absolute !important;\n    top: 0;\n    right: 0;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n    margin: ${n("galleria.close.button.gutter")};\n    background: ${n("galleria.close.button.background")};\n    color: ${n("galleria.close.button.color")};\n    width: ${n("galleria.close.button.size")};\n    height: ${n("galleria.close.button.size")};\n    padding: 0;\n    border: none;\n    user-select: none;\n    cursor: pointer;\n    border-radius: ${n("galleria.close.button.border.radius")};\n    outline-color: transparent;\n    transition: background ${n("galleria.transition.duration")}, color ${n("galleria.transition.duration")}, outline-color ${n("galleria.transition.duration")};\n}\n\n.p-galleria-close-icon {\n    font-size: ${n("galleria.close.button.icon.size")};\n    width: ${n("galleria.close.button.icon.size")};\n    height: ${n("galleria.close.button.icon.size")};\n}\n\n.p-galleria-close-button:hover {\n    background: ${n("galleria.close.button.hover.background")};\n    color: ${n("galleria.close.button.hover.color")};\n}\n\n.p-galleria-close-button:focus-visible {\n    box-shadow: ${n("galleria.close.button.focus.ring.shadow")};\n    outline: ${n("galleria.close.button.focus.ring.width")} ${n("galleria.close.button.focus.ring.style")} ${n("galleria.close.button.focus.ring.color")};\n    outline-offset: ${n("galleria.close.button.focus.ring.offset")};\n}\n\n.p-galleria-mask .p-galleria-nav-button {\n    position: fixed;\n    top: 50%;\n}\n\n.p-galleria-enter-active {\n    transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n}\n\n.p-galleria-leave-active {\n    transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.p-galleria-enter-from,\n.p-galleria-leave-to {\n    opacity: 0;\n    transform: scale(0.7);\n}\n\n.p-galleria-enter-active .p-galleria-nav-button {\n    opacity: 0;\n}\n\n.p-items-hidden .p-galleria-thumbnail-item {\n    visibility: hidden;\n}\n\n.p-items-hidden .p-galleria-thumbnail-item.p-galleria-thumbnail-item-active {\n    visibility: visible;\n}\n`;export{style};//# sourceMappingURL=index.mjs.map