var style=({dt:e})=>`\n.p-datepicker {\n    display: inline-flex;\n    max-width: 100%;\n}\n\n.p-datepicker-input {\n    flex: 1 1 auto;\n    width: 1%;\n}\n\n.p-datepicker:has(.p-datepicker-dropdown) .p-datepicker-input {\n    border-start-end-radius: 0;\n    border-end-end-radius: 0;\n}\n\n.p-datepicker-dropdown {\n    cursor: pointer;\n    display: inline-flex;\n    user-select: none;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n    width: ${e("datepicker.dropdown.width")};\n    border-start-end-radius: ${e("datepicker.dropdown.border.radius")};\n    border-end-end-radius: ${e("datepicker.dropdown.border.radius")};\n    background: ${e("datepicker.dropdown.background")};\n    border: 1px solid ${e("datepicker.dropdown.border.color")};\n    border-inline-start: 0 none;\n    color: ${e("datepicker.dropdown.color")};\n    transition: background ${e("datepicker.transition.duration")}, color ${e("datepicker.transition.duration")}, border-color ${e("datepicker.transition.duration")}, outline-color ${e("datepicker.transition.duration")};\n    outline-color: transparent;\n}\n\n.p-datepicker-dropdown:not(:disabled):hover {\n    background: ${e("datepicker.dropdown.hover.background")};\n    border-color: ${e("datepicker.dropdown.hover.border.color")};\n    color: ${e("datepicker.dropdown.hover.color")};\n}\n\n.p-datepicker-dropdown:not(:disabled):active {\n    background: ${e("datepicker.dropdown.active.background")};\n    border-color: ${e("datepicker.dropdown.active.border.color")};\n    color: ${e("datepicker.dropdown.active.color")};\n}\n\n.p-datepicker-dropdown:focus-visible {\n    box-shadow: ${e("datepicker.dropdown.focus.ring.shadow")};\n    outline: ${e("datepicker.dropdown.focus.ring.width")} ${e("datepicker.dropdown.focus.ring.style")} ${e("datepicker.dropdown.focus.ring.color")};\n    outline-offset: ${e("datepicker.dropdown.focus.ring.offset")};\n}\n\n.p-datepicker:has(.p-datepicker-input-icon-container) {\n    position: relative;\n}\n\n.p-datepicker:has(.p-datepicker-input-icon-container) .p-datepicker-input {\n    padding-inline-end: calc((${e("form.field.padding.x")} * 2) + ${e("icon.size")});\n}\n\n.p-datepicker-input-icon-container {\n    cursor: pointer;\n    position: absolute;\n    top: 50%;\n    inset-inline-end: ${e("form.field.padding.x")};\n    margin-block-start: calc(-1 * (${e("icon.size")} / 2));\n    color: ${e("datepicker.input.icon.color")};\n    line-height: 1;\n}\n\n.p-datepicker-fluid {\n    display: flex;\n}\n\n.p-datepicker-fluid .p-datepicker-input {\n    width: 1%;\n}\n\n.p-datepicker .p-datepicker-panel {\n    min-width: 100%;\n}\n\n.p-datepicker-panel {\n    width: auto;\n    padding: ${e("datepicker.panel.padding")};\n    background: ${e("datepicker.panel.background")};\n    color: ${e("datepicker.panel.color")};\n    border: 1px solid ${e("datepicker.panel.border.color")};\n    border-radius: ${e("datepicker.panel.border.radius")};\n    box-shadow: ${e("datepicker.panel.shadow")};\n}\n\n.p-datepicker-panel-inline {\n    display: inline-block;\n    overflow-x: auto;\n    box-shadow: none;\n}\n\n.p-datepicker-header {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    padding: ${e("datepicker.header.padding")};\n    background: ${e("datepicker.header.background")};\n    color: ${e("datepicker.header.color")};\n    border-block-end: 1px solid ${e("datepicker.header.border.color")};\n}\n\n.p-datepicker-next-button:dir(rtl) {\n    order: -1;\n}\n\n.p-datepicker-prev-button:dir(rtl) {\n    order: 1;\n}\n\n.p-datepicker-title {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    gap: ${e("datepicker.title.gap")};\n    font-weight: ${e("datepicker.title.font.weight")};\n}\n\n.p-datepicker-select-year,\n.p-datepicker-select-month {\n    border: none;\n    background: transparent;\n    margin: 0;\n    cursor: pointer;\n    font-weight: inherit;\n    transition: background ${e("datepicker.transition.duration")}, color ${e("datepicker.transition.duration")}, border-color ${e("datepicker.transition.duration")}, outline-color ${e("datepicker.transition.duration")}, box-shadow ${e("datepicker.transition.duration")};\n}\n\n.p-datepicker-select-month {\n    padding: ${e("datepicker.select.month.padding")};\n    color: ${e("datepicker.select.month.color")};\n    border-radius: ${e("datepicker.select.month.border.radius")};\n}\n\n.p-datepicker-select-year {\n    padding: ${e("datepicker.select.year.padding")};\n    color: ${e("datepicker.select.year.color")};\n    border-radius: ${e("datepicker.select.year.border.radius")};\n}\n\n.p-datepicker-select-month:enabled:hover {\n    background: ${e("datepicker.select.month.hover.background")};\n    color: ${e("datepicker.select.month.hover.color")};\n}\n\n.p-datepicker-select-year:enabled:hover {\n    background: ${e("datepicker.select.year.hover.background")};\n    color: ${e("datepicker.select.year.hover.color")};\n}\n\n.p-datepicker-select-month:focus-visible,\n.p-datepicker-select-year:focus-visible {\n    box-shadow: ${e("datepicker.date.focus.ring.shadow")};\n    outline: ${e("datepicker.date.focus.ring.width")} ${e("datepicker.date.focus.ring.style")} ${e("datepicker.date.focus.ring.color")};\n    outline-offset: ${e("datepicker.date.focus.ring.offset")};\n}\n\n.p-datepicker-calendar-container {\n    display: flex;\n}\n\n.p-datepicker-calendar-container .p-datepicker-calendar {\n    flex: 1 1 auto;\n    border-inline-start: 1px solid ${e("datepicker.group.border.color")};\n    padding-inline-end: ${e("datepicker.group.gap")};\n    padding-inline-start: ${e("datepicker.group.gap")};\n}\n\n.p-datepicker-calendar-container .p-datepicker-calendar:first-child {\n    padding-inline-start: 0;\n    border-inline-start: 0 none;\n}\n\n.p-datepicker-calendar-container .p-datepicker-calendar:last-child {\n    padding-inline-end: 0;\n}\n\n.p-datepicker-day-view {\n    width: 100%;\n    border-collapse: collapse;\n    font-size: 1rem;\n    margin: ${e("datepicker.day.view.margin")};\n}\n\n.p-datepicker-weekday-cell {\n    padding: ${e("datepicker.week.day.padding")};\n}\n\n.p-datepicker-weekday {\n    font-weight: ${e("datepicker.week.day.font.weight")};\n    color: ${e("datepicker.week.day.color")};\n}\n\n.p-datepicker-day-cell {\n    padding: ${e("datepicker.date.padding")};\n}\n\n.p-datepicker-day {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    cursor: pointer;\n    margin: 0 auto;\n    overflow: hidden;\n    position: relative;\n    width: ${e("datepicker.date.width")};\n    height: ${e("datepicker.date.height")};\n    border-radius: ${e("datepicker.date.border.radius")};\n    transition: background ${e("datepicker.transition.duration")}, color ${e("datepicker.transition.duration")}, border-color ${e("datepicker.transition.duration")}, box-shadow ${e("datepicker.transition.duration")}, outline-color ${e("datepicker.transition.duration")};\n    border: 1px solid transparent;\n    outline-color: transparent;\n    color: ${e("datepicker.date.color")};\n}\n\n.p-datepicker-day:not(.p-datepicker-day-selected):not(.p-disabled):hover {\n    background: ${e("datepicker.date.hover.background")};\n    color: ${e("datepicker.date.hover.color")};\n}\n\n.p-datepicker-day:focus-visible {\n    box-shadow: ${e("datepicker.date.focus.ring.shadow")};\n    outline: ${e("datepicker.date.focus.ring.width")} ${e("datepicker.date.focus.ring.style")} ${e("datepicker.date.focus.ring.color")};\n    outline-offset: ${e("datepicker.date.focus.ring.offset")};\n}\n\n.p-datepicker-day-selected {\n    background: ${e("datepicker.date.selected.background")};\n    color: ${e("datepicker.date.selected.color")};\n}\n\n.p-datepicker-day-selected-range {\n    background: ${e("datepicker.date.range.selected.background")};\n    color: ${e("datepicker.date.range.selected.color")};\n}\n\n.p-datepicker-today > .p-datepicker-day {\n    background: ${e("datepicker.today.background")};\n    color: ${e("datepicker.today.color")};\n}\n\n.p-datepicker-today > .p-datepicker-day-selected {\n    background: ${e("datepicker.date.selected.background")};\n    color: ${e("datepicker.date.selected.color")};\n}\n\n.p-datepicker-today > .p-datepicker-day-selected-range {\n    background: ${e("datepicker.date.range.selected.background")};\n    color: ${e("datepicker.date.range.selected.color")};\n}\n\n.p-datepicker-weeknumber {\n    text-align: center;\n}\n\n.p-datepicker-month-view {\n    margin: ${e("datepicker.month.view.margin")};\n}\n\n.p-datepicker-month {\n    width: 33.3%;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    overflow: hidden;\n    position: relative;\n    padding: ${e("datepicker.month.padding")};\n    transition: background ${e("datepicker.transition.duration")}, color ${e("datepicker.transition.duration")}, border-color ${e("datepicker.transition.duration")}, box-shadow ${e("datepicker.transition.duration")}, outline-color ${e("datepicker.transition.duration")};\n    border-radius: ${e("datepicker.month.border.radius")};\n    outline-color: transparent;\n    color: ${e("datepicker.date.color")};\n}\n\n.p-datepicker-month:not(.p-disabled):not(.p-datepicker-month-selected):hover {\n    color: ${e("datepicker.date.hover.color")};\n    background: ${e("datepicker.date.hover.background")};\n}\n\n.p-datepicker-month-selected {\n    color: ${e("datepicker.date.selected.color")};\n    background: ${e("datepicker.date.selected.background")};\n}\n\n.p-datepicker-month:not(.p-disabled):focus-visible {\n    box-shadow: ${e("datepicker.date.focus.ring.shadow")};\n    outline: ${e("datepicker.date.focus.ring.width")} ${e("datepicker.date.focus.ring.style")} ${e("datepicker.date.focus.ring.color")};\n    outline-offset: ${e("datepicker.date.focus.ring.offset")};\n}\n\n.p-datepicker-year-view {\n    margin: ${e("datepicker.year.view.margin")};\n}\n\n.p-datepicker-year {\n    width: 50%;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    overflow: hidden;\n    position: relative;\n    padding: ${e("datepicker.year.padding")};\n    transition: background ${e("datepicker.transition.duration")}, color ${e("datepicker.transition.duration")}, border-color ${e("datepicker.transition.duration")}, box-shadow ${e("datepicker.transition.duration")}, outline-color ${e("datepicker.transition.duration")};\n    border-radius: ${e("datepicker.year.border.radius")};\n    outline-color: transparent;\n    color: ${e("datepicker.date.color")};\n}\n\n.p-datepicker-year:not(.p-disabled):not(.p-datepicker-year-selected):hover {\n    color: ${e("datepicker.date.hover.color")};\n    background: ${e("datepicker.date.hover.background")};\n}\n\n.p-datepicker-year-selected {\n    color: ${e("datepicker.date.selected.color")};\n    background: ${e("datepicker.date.selected.background")};\n}\n\n.p-datepicker-year:not(.p-disabled):focus-visible {\n    box-shadow: ${e("datepicker.date.focus.ring.shadow")};\n    outline: ${e("datepicker.date.focus.ring.width")} ${e("datepicker.date.focus.ring.style")} ${e("datepicker.date.focus.ring.color")};\n    outline-offset: ${e("datepicker.date.focus.ring.offset")};\n}\n\n.p-datepicker-buttonbar {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    padding: ${e("datepicker.buttonbar.padding")};\n    border-block-start: 1px solid ${e("datepicker.buttonbar.border.color")};\n}\n\n.p-datepicker-buttonbar .p-button {\n    width: auto;\n}\n\n.p-datepicker-time-picker {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    border-block-start: 1px solid ${e("datepicker.time.picker.border.color")};\n    padding: 0;\n    gap: ${e("datepicker.time.picker.gap")};\n}\n\n.p-datepicker-calendar-container + .p-datepicker-time-picker {\n    padding: ${e("datepicker.time.picker.padding")};\n}\n\n.p-datepicker-time-picker > div {\n    display: flex;\n    align-items: center;\n    flex-direction: column;\n    gap: ${e("datepicker.time.picker.button.gap")};\n}\n\n.p-datepicker-time-picker span {\n    font-size: 1rem;\n}\n\n.p-datepicker-timeonly .p-datepicker-time-picker {\n    border-block-start: 0 none;\n}\n\n.p-datepicker:has(.p-inputtext-sm) .p-datepicker-dropdown {\n    width: ${e("datepicker.dropdown.sm.width")};\n}\n\n.p-datepicker:has(.p-inputtext-sm) .p-datepicker-dropdown .p-icon,\n.p-datepicker:has(.p-inputtext-sm) .p-datepicker-input-icon {\n    font-size: ${e("form.field.sm.font.size")};\n    width: ${e("form.field.sm.font.size")};\n    height: ${e("form.field.sm.font.size")};\n}\n\n.p-datepicker:has(.p-inputtext-lg) .p-datepicker-dropdown {\n    width: ${e("datepicker.dropdown.lg.width")};\n}\n\n.p-datepicker:has(.p-inputtext-lg) .p-datepicker-dropdown .p-icon,\n.p-datepicker:has(.p-inputtext-lg) .p-datepicker-input-icon {\n    font-size: ${e("form.field.lg.font.size")};\n    width: ${e("form.field.lg.font.size")};\n    height: ${e("form.field.lg.font.size")};\n}\n`;export{style};//# sourceMappingURL=index.mjs.map