var style=({dt:n})=>`\n.p-contextmenu {\n    background: ${n("contextmenu.background")};\n    color: ${n("contextmenu.color")};\n    border: 1px solid ${n("contextmenu.border.color")};\n    border-radius: ${n("contextmenu.border.radius")};\n    box-shadow: ${n("contextmenu.shadow")};\n    min-width: 12.5rem;\n}\n\n.p-contextmenu-root-list,\n.p-contextmenu-submenu {\n    margin: 0;\n    padding: ${n("contextmenu.list.padding")};\n    list-style: none;\n    outline: 0 none;\n    display: flex;\n    flex-direction: column;\n    gap: ${n("contextmenu.list.gap")};\n}\n\n.p-contextmenu-submenu {\n    position: absolute;\n    display: flex;\n    flex-direction: column;\n    min-width: 100%;\n    z-index: 1;\n    background: ${n("contextmenu.background")};\n    color: ${n("contextmenu.color")};\n    border: 1px solid ${n("contextmenu.border.color")};\n    border-radius: ${n("contextmenu.border.radius")};\n    box-shadow: ${n("contextmenu.shadow")};\n}\n\n.p-contextmenu-item {\n    position: relative;\n}\n\n.p-contextmenu-item-content {\n    transition: background ${n("contextmenu.transition.duration")}, color ${n("contextmenu.transition.duration")};\n    border-radius: ${n("contextmenu.item.border.radius")};\n    color: ${n("contextmenu.item.color")};\n}\n\n.p-contextmenu-item-link {\n    cursor: pointer;\n    display: flex;\n    align-items: center;\n    text-decoration: none;\n    overflow: hidden;\n    position: relative;\n    color: inherit;\n    padding: ${n("contextmenu.item.padding")};\n    gap: ${n("contextmenu.item.gap")};\n    user-select: none;\n}\n\n.p-contextmenu-item-label {\n    line-height: 1;\n}\n\n.p-contextmenu-item-icon {\n    color: ${n("contextmenu.item.icon.color")};\n}\n\n.p-contextmenu-submenu-icon {\n    color: ${n("contextmenu.submenu.icon.color")};\n    margin-left: auto;\n    font-size: ${n("contextmenu.submenu.icon.size")};\n    width: ${n("contextmenu.submenu.icon.size")};\n    height: ${n("contextmenu.submenu.icon.size")};\n}\n\n.p-contextmenu-submenu-icon:dir(rtl) {\n    margin-left: 0;\n    margin-right: auto;\n}\n\n.p-contextmenu-item.p-focus > .p-contextmenu-item-content {\n    color: ${n("contextmenu.item.focus.color")};\n    background: ${n("contextmenu.item.focus.background")};\n}\n\n.p-contextmenu-item.p-focus > .p-contextmenu-item-content .p-contextmenu-item-icon {\n    color: ${n("contextmenu.item.icon.focus.color")};\n}\n\n.p-contextmenu-item.p-focus > .p-contextmenu-item-content .p-contextmenu-submenu-icon {\n    color: ${n("contextmenu.submenu.icon.focus.color")};\n}\n\n.p-contextmenu-item:not(.p-disabled) > .p-contextmenu-item-content:hover {\n    color: ${n("contextmenu.item.focus.color")};\n    background: ${n("contextmenu.item.focus.background")};\n}\n\n.p-contextmenu-item:not(.p-disabled) > .p-contextmenu-item-content:hover .p-contextmenu-item-icon {\n    color: ${n("contextmenu.item.icon.focus.color")};\n}\n\n.p-contextmenu-item:not(.p-disabled) > .p-contextmenu-item-content:hover .p-contextmenu-submenu-icon {\n    color: ${n("contextmenu.submenu.icon.focus.color")};\n}\n\n.p-contextmenu-item-active > .p-contextmenu-item-content {\n    color: ${n("contextmenu.item.active.color")};\n    background: ${n("contextmenu.item.active.background")};\n}\n\n.p-contextmenu-item-active > .p-contextmenu-item-content .p-contextmenu-item-icon {\n    color: ${n("contextmenu.item.icon.active.color")};\n}\n\n.p-contextmenu-item-active > .p-contextmenu-item-content .p-contextmenu-submenu-icon {\n    color: ${n("contextmenu.submenu.icon.active.color")};\n}\n\n.p-contextmenu-separator {\n    border-block-start: 1px solid ${n("contextmenu.separator.border.color")};\n}\n\n.p-contextmenu-enter-from,\n.p-contextmenu-leave-active {\n    opacity: 0;\n}\n\n.p-contextmenu-enter-active {\n    transition: opacity 250ms;\n}\n\n.p-contextmenu-mobile .p-contextmenu-submenu {\n    position: static;\n    box-shadow: none;\n    border: 0 none;\n    padding-inline-start: ${n("tieredmenu.submenu.mobile.indent")};\n    padding-inline-end: 0;\n}\n\n.p-contextmenu-mobile .p-contextmenu-submenu-icon {\n    transition: transform 0.2s;\n    transform: rotate(90deg);\n}\n\n.p-contextmenu-mobile .p-contextmenu-item-active > .p-contextmenu-item-content .p-contextmenu-submenu-icon {\n    transform: rotate(-90deg);\n}\n`;export{style};//# sourceMappingURL=index.mjs.map