var style=({dt:e})=>`\n.p-cascadeselect {\n    display: inline-flex;\n    cursor: pointer;\n    position: relative;\n    user-select: none;\n    background: ${e("cascadeselect.background")};\n    border: 1px solid ${e("cascadeselect.border.color")};\n    transition: background ${e("cascadeselect.transition.duration")}, color ${e("cascadeselect.transition.duration")}, border-color ${e("cascadeselect.transition.duration")}, outline-color ${e("cascadeselect.transition.duration")}, box-shadow ${e("cascadeselect.transition.duration")};\n    border-radius: ${e("cascadeselect.border.radius")};\n    outline-color: transparent;\n    box-shadow: ${e("cascadeselect.shadow")};\n}\n\n.p-cascadeselect:not(.p-disabled):hover {\n    border-color: ${e("cascadeselect.hover.border.color")};\n}\n\n.p-cascadeselect:not(.p-disabled).p-focus {\n    border-color: ${e("cascadeselect.focus.border.color")};\n    box-shadow: ${e("cascadeselect.focus.ring.shadow")};\n    outline: ${e("cascadeselect.focus.ring.width")} ${e("cascadeselect.focus.ring.style")} ${e("cascadeselect.focus.ring.color")};\n    outline-offset: ${e("cascadeselect.focus.ring.offset")};\n}\n\n.p-cascadeselect.p-variant-filled {\n    background: ${e("cascadeselect.filled.background")};\n}\n\n.p-cascadeselect.p-variant-filled:not(.p-disabled):hover {\n    background: ${e("cascadeselect.filled.hover.background")};\n}\n\n.p-cascadeselect.p-variant-filled.p-focus {\n    background: ${e("cascadeselect.filled.focus.background")};\n}\n\n.p-cascadeselect.p-invalid {\n    border-color: ${e("cascadeselect.invalid.border.color")};\n}\n\n.p-cascadeselect.p-disabled {\n    opacity: 1;\n    background: ${e("cascadeselect.disabled.background")};\n}\n\n.p-cascadeselect-dropdown {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    flex-shrink: 0;\n    background: transparent;\n    color: ${e("cascadeselect.dropdown.color")};\n    width: ${e("cascadeselect.dropdown.width")};\n    border-start-end-radius: ${e("border.radius.md")};\n    border-end-end-radius: ${e("border.radius.md")};\n}\n\n.p-cascadeselect-clear-icon {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n    color: ${e("cascadeselect.clear.icon.color")};\n    inset-inline-end: ${e("cascadeselect.dropdown.width")};\n}\n\n.p-cascadeselect-label {\n    display: block;\n    white-space: nowrap;\n    overflow: hidden;\n    flex: 1 1 auto;\n    width: 1%;\n    text-overflow: ellipsis;\n    cursor: pointer;\n    padding: ${e("cascadeselect.padding.y")} ${e("cascadeselect.padding.x")};\n    background: transparent;\n    border: 0 none;\n    outline: 0 none;\n}\n\n.p-cascadeselect-label.p-placeholder {\n    color: ${e("cascadeselect.placeholder.color")};\n}\n\n.p-cascadeselect.p-invalid .p-cascadeselect-label.p-placeholder {\n    color: ${e("cascadeselect.invalid.placeholder.color")};\n}\n\n.p-cascadeselect.p-disabled .p-cascadeselect-label {\n    color: ${e("cascadeselect.disabled.color")};\n}\n\n.p-cascadeselect-label-empty {\n    overflow: hidden;\n    visibility: hidden;\n}\n\n.p-cascadeselect-fluid {\n    display: flex;\n}\n\n.p-cascadeselect-fluid .p-cascadeselect-label {\n    width: 1%;\n}\n\n.p-cascadeselect-overlay {\n    background: ${e("cascadeselect.overlay.background")};\n    color: ${e("cascadeselect.overlay.color")};\n    border: 1px solid ${e("cascadeselect.overlay.border.color")};\n    border-radius: ${e("cascadeselect.overlay.border.radius")};\n    box-shadow: ${e("cascadeselect.overlay.shadow")};\n}\n\n.p-cascadeselect .p-cascadeselect-overlay {\n    min-width: 100%;\n}\n\n.p-cascadeselect-option-list {\n    display: none;\n    min-width: 100%;\n    position: absolute;\n    z-index: 1;\n}\n\n.p-cascadeselect-list {\n    min-width: 100%;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    padding: ${e("cascadeselect.list.padding")};\n    display: flex;\n    flex-direction: column;\n    gap: ${e("cascadeselect.list.gap")};\n}\n\n.p-cascadeselect-option {\n    cursor: pointer;\n    font-weight: normal;\n    white-space: nowrap;\n    border: 0 none;\n    color: ${e("cascadeselect.option.color")};\n    background: transparent;\n    border-radius: ${e("cascadeselect.option.border.radius")};\n}\n\n.p-cascadeselect-option-active {\n    overflow: visible;\n}\n\n.p-cascadeselect-option-active > .p-cascadeselect-option-content {\n    background: ${e("cascadeselect.option.focus.background")};\n    color: ${e("cascadeselect.option.focus.color")};\n}\n\n.p-cascadeselect-option:not(.p-cascadeselect-option-selected):not(.p-disabled).p-focus > .p-cascadeselect-option-content {\n    background: ${e("cascadeselect.option.focus.background")};\n    color: ${e("cascadeselect.option.focus.color")};\n}\n\n.p-cascadeselect-option:not(.p-cascadeselect-option-selected):not(.p-disabled).p-focus > .p-cascadeselect-option-content > .p-cascadeselect-group-icon-container > .p-cascadeselect-group-icon {\n    color: ${e("cascadeselect.option.icon.focus.color")};\n}\n\n.p-cascadeselect-option-selected > .p-cascadeselect-option-content {\n    background: ${e("cascadeselect.option.selected.background")};\n    color: ${e("cascadeselect.option.selected.color")};\n}\n\n.p-cascadeselect-option-selected.p-focus > .p-cascadeselect-option-content {\n    background: ${e("cascadeselect.option.selected.focus.background")};\n    color: ${e("cascadeselect.option.selected.focus.color")};\n}\n\n.p-cascadeselect-option-active > .p-cascadeselect-option-list {\n    inset-inline-start: 100%;\n    inset-block-start: 0;\n}\n\n.p-cascadeselect-option-content {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    overflow: hidden;\n    position: relative;\n    padding: ${e("cascadeselect.option.padding")};\n    border-radius: ${e("cascadeselect.option.border.radius")};\n    transition: background ${e("cascadeselect.transition.duration")}, color ${e("cascadeselect.transition.duration")}, border-color ${e("cascadeselect.transition.duration")}, box-shadow ${e("cascadeselect.transition.duration")}, outline-color ${e("cascadeselect.transition.duration")};\n}\n\n.p-cascadeselect-group-icon {\n    font-size: ${e("cascadeselect.option.icon.size")};\n    width: ${e("cascadeselect.option.icon.size")};\n    height: ${e("cascadeselect.option.icon.size")};\n    color: ${e("cascadeselect.option.icon.color")};\n}\n\n.p-cascadeselect-group-icon:dir(rtl) {\n    transform: rotate(180deg);\n}\n\n.p-cascadeselect-mobile-active .p-cascadeselect-option-list {\n    position: static;\n    box-shadow: none;\n    border: 0 none;\n    padding-inline-start: ${e("tieredmenu.submenu.mobile.indent")};\n    padding-inline-end: 0;\n}\n\n.p-cascadeselect-mobile-active .p-cascadeselect-group-icon {\n    transition: transform 0.2s;\n    transform: rotate(90deg);\n}\n\n.p-cascadeselect-mobile-active .p-cascadeselect-option-active > .p-cascadeselect-option-content .p-cascadeselect-group-icon {\n    transform: rotate(-90deg);\n}\n\n.p-cascadeselect-sm .p-cascadeselect-label {\n    font-size: ${e("cascadeselect.sm.font.size")};\n    padding-block: ${e("cascadeselect.sm.padding.y")};\n    padding-inline: ${e("cascadeselect.sm.padding.x")};\n}\n\n.p-cascadeselect-sm .p-cascadeselect-dropdown .p-icon {\n    font-size: ${e("cascadeselect.sm.font.size")};\n    width: ${e("cascadeselect.sm.font.size")};\n    height: ${e("cascadeselect.sm.font.size")};\n}\n\n.p-cascadeselect-lg .p-cascadeselect-label {\n    font-size: ${e("cascadeselect.lg.font.size")};\n    padding-block: ${e("cascadeselect.lg.padding.y")};\n    padding-inline: ${e("cascadeselect.lg.padding.x")};\n}\n\n.p-cascadeselect-lg .p-cascadeselect-dropdown .p-icon {\n    font-size: ${e("cascadeselect.lg.font.size")};\n    width: ${e("cascadeselect.lg.font.size")};\n    height: ${e("cascadeselect.lg.font.size")};\n}\n`;export{style};//# sourceMappingURL=index.mjs.map