interface BlockBodyScrollOptions {
    className?: string;
    variableName?: string;
}
declare function blockBodyScroll(option: string | BlockBodyScrollOptions | undefined): void;

declare function exportCSV(csv: any, filename: string): void;

declare function saveAs(file: {
    name: string;
    src: string;
}): boolean;

interface UnblockBodyScrollOptions {
    className?: string;
    variableName?: string;
}
declare function unblockBodyScroll(option: string | UnblockBodyScrollOptions | undefined): void;

declare function absolutePosition(element: HTMLElement, target: HTMLElement, gutter?: boolean): void;

declare function addClass(element: Element, className: string | string[]): void;

declare function addStyle(element: HTMLElement, style: string | object): void;

declare function alignOverlay(overlay: HTMLElement, target: HTMLElement, appendTo: string, calculateMinWidth?: boolean): void;

declare function appendChild(element: unknown, child: Node | Element): void;

declare function calculateBodyScrollbarWidth(): number;

declare function calculateScrollbarHeight(element?: HTMLElement): number;

declare function calculateScrollbarWidth(element?: HTMLElement): number;

declare function clearSelection(): void;

declare function createElement(type: string, attributes?: {
    [key: string]: any;
}, ...children: (string | Node)[]): HTMLElement | undefined;

declare function createStyleAsString(css: string, options?: any): string;

declare function createStyleTag(attributes: {
    [key: string]: any;
} | undefined, container: Element): HTMLStyleElement;

declare function fadeIn(element: HTMLElement, duration: number): void;

declare function fadeOut(element: HTMLElement, duration: number): void;

declare function find(element: Element, selector: string): Element[];

declare function findSingle(element: Element, selector: string): Element | null;

declare function focus(element: HTMLElement, options?: FocusOptions): void;

declare function getAttribute(element: Element, name: string): any;

type BrowserType = {
    [key: string]: string | boolean | undefined;
};
declare function getBrowser(): BrowserType;

declare function getBrowserLanguage(): string;

declare function getCSSProperty(element?: HTMLElement, property?: string, inline?: boolean): string | null;

declare function getCSSVariableByRegex(variableRegex: RegExp): {
    name: string | undefined;
    value: string | undefined;
} | null;

declare function getCursorOffset(element: Element, prevText: string, nextText: string, currentText: string): {
    top: number | string;
    left: number | string;
};

declare function getFirstFocusableElement(element: Element, selector?: string): Element | null;

declare function getFocusableElements(element: Element, selector?: string): Element[];

declare function getHeight(element: HTMLElement): number;

declare function getHiddenElementDimensions(element?: HTMLElement): {
    width: number;
    height: number;
};

declare function getHiddenElementOuterHeight(element: HTMLElement): number;

declare function getHiddenElementOuterWidth(element: HTMLElement): number;

declare function getIndex(element: HTMLElement): number;

declare function getInnerWidth(element: HTMLElement): number;

declare function getLastFocusableElement(element: Element, selector?: string): Element | null;

declare function getNextElementSibling(element: Element, selector: string): Element | null;

declare function getNextFocusableElement(container: Element, element: Element, selector?: string): Element | null;

declare function getOffset(element?: Element | null): {
    top: number | string;
    left: number | string;
};

declare function getOuterHeight(element: HTMLElement, margin?: boolean): number;

declare function getOuterWidth(element: unknown, margin?: boolean): number;

declare function getParentNode(element: Node): ParentNode | null;

declare function getParents(element: Node, parents?: ParentNode[]): ParentNode[];

declare function getPreviousElementSibling(element: Element, selector: string): Element | null;

declare function getScrollLeft(element?: HTMLElement): number;

declare function getScrollableParents(element: Element): Element[];

declare function getSelection(): string | undefined;

declare function getTargetElement(target: any, currentElement: Element): Window | Document | Element | null | undefined;

declare function getUserAgent(): string;

declare function getViewport(): {
    width: number;
    height: number;
};

declare function getWidth(element: HTMLElement): number;

declare function getWindowScrollLeft(): number;

declare function getWindowScrollTop(): number;

declare function hasCSSAnimation(element: Element): boolean;

declare function hasCSSTransition(element: Element): boolean;

declare function hasClass(element: Element, className: string): boolean;

declare function invokeElementMethod(element: Element, methodName: string, args?: any[]): void;

declare function isAndroid(): boolean;

declare function isAttributeEquals(element: Element, name: string, value: any): boolean;

declare function isAttributeNotEquals(element: Element, name: string, value: any): boolean;

declare function isClickable(element: Element): boolean;

declare function isClient(): boolean;

declare function isElement(element: any): boolean;

declare function isExist(element: Node): boolean;

declare function isFocusableElement(element: unknown, selector?: string): boolean;

declare function isHidden(element: HTMLElement): boolean;

declare function isIOS(): boolean;

declare function isRTL(element?: HTMLElement): boolean;

declare function isServer(): boolean;

declare function isTouchDevice(): boolean;

declare function isVisible(element?: HTMLElement): boolean;

declare function nestedPosition(element: HTMLElement, level: number): void;

declare function relativePosition(element: HTMLElement, target: HTMLElement, gutter?: boolean): void;

declare function remove(element: Element): void;

declare function removeChild(element: unknown, child: Node): void;

declare function removeClass(element: Element, className: string | string[]): void;

declare function removeStyleTag(element: Node): Node | null;

declare function resolveUserAgent(): {
    browser: string | undefined;
    version: string | undefined;
};

declare function scrollInView(container: HTMLElement, item: HTMLElement): void;

declare function setAttribute(element: HTMLElement, attribute: string | undefined, value: any): void;

declare function setAttributes(element: HTMLElement, attributes?: {
    [key: string]: any;
}): void;

declare function setCSSProperty(element?: HTMLElement, property?: string, value?: any, priority?: string): void;

declare function toElement(element: any): Element | undefined;

export { absolutePosition, addClass, addStyle, alignOverlay, appendChild, blockBodyScroll, calculateBodyScrollbarWidth, calculateScrollbarHeight, calculateScrollbarWidth, clearSelection, createElement, createStyleAsString, createStyleTag, exportCSV, fadeIn, fadeOut, find, findSingle, focus, getAttribute, getBrowser, getBrowserLanguage, getCSSProperty, getCSSVariableByRegex, getCursorOffset, getFirstFocusableElement, getFocusableElements, getHeight, getHiddenElementDimensions, getHiddenElementOuterHeight, getHiddenElementOuterWidth, getIndex, getInnerWidth, getLastFocusableElement, getNextElementSibling, getNextFocusableElement, getOffset, getOuterHeight, getOuterWidth, getParentNode, getParents, getPreviousElementSibling, getScrollLeft, getScrollableParents, getSelection, getTargetElement, getUserAgent, getViewport, getWidth, getWindowScrollLeft, getWindowScrollTop, hasCSSAnimation, hasCSSTransition, hasClass, invokeElementMethod, isAndroid, isAttributeEquals, isAttributeNotEquals, isClickable, isClient, isElement, isExist, isFocusableElement, isHidden, isIOS, isRTL, isServer, isTouchDevice, isVisible, nestedPosition, relativePosition, remove, removeChild, removeClass, removeStyleTag, resolveUserAgent, saveAs, scrollInView, setAttribute, setAttributes, setCSSProperty, toElement, unblockBodyScroll };
