<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('imagini', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_piesa')->nullable()->constrained('piese');
            $table->foreignId('id_piesa_stoc')->nullable()->constrained('stoc_piese');
            $table->foreignId('id_model')->nullable()->constrained('modele');
            $table->foreignId('id_masina_stoc')->nullable()->constrained('stoc_masini');
            $table->string('url');
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('imagini');
    }
};
