<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cantitati_ajustate_piese', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_piesa')->constrained('piese');
            $table->foreignId('id_model')->nullable()->constrained('modele');
            $table->integer('nr_usi')->nullable();
            $table->string('combustibil')->nullable();
            $table->string('transmisie')->nullable();
            $table->integer('numar_viteze')->nullable();
            $table->boolean('jante')->default(false);
            $table->boolean('cauciucuri_fata')->default(false);
            $table->boolean('cauciucuri_spate')->default(false);
            $table->integer('cantitate')->default(0);
            $table->boolean('activ')->default(true);
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cantitati_ajustate_piese');
    }
};
