<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stoc_piese', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_model')->constrained('modele');
            $table->foreignId('id_stoc_masina')->constrained('stoc_masini');
            $table->foreignId('id_piesa')->constrained('piese');
            $table->integer('cantitate')->default(1);
            $table->string('nume');
            $table->string('cod_piesa')->nullable();
            $table->string('locatie_depozit')->nullable();
            $table->year('an_productie')->nullable();
            $table->float('capacitate_motor')->nullable();
            $table->string('combustibil')->nullable();
            $table->string('cod_motor')->nullable();
            $table->integer('putere_motor')->nullable();
            $table->string('tip_caroserie')->nullable();
            $table->string('serie_sasiu')->nullable();
            $table->string('status')->default('in_stoc');
            $table->text('observatii')->nullable();
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stoc_piese');
    }
};
