<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stoc_masini', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_marca')->constrained('marci');
            $table->foreignId('id_model')->constrained('modele');
            $table->year('an_productie')->nullable();
            $table->float('capacitate_motor')->nullable();
            $table->string('combustibil')->nullable();
            $table->string('cod_motor')->nullable();
            $table->integer('putere_motor')->nullable();
            $table->string('tip_caroserie')->nullable();
            $table->string('serie_sasiu')->nullable();
            $table->string('culoare')->nullable();
            $table->string('status')->default('nou');
            $table->text('observatii')->nullable();
            $table->float('greutate_service')->nullable();
            $table->float('greutate_receptie')->nullable();
            $table->text('piese_lipsa')->nullable();
            $table->string('cod_parc')->nullable();
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stoc_masini');
    }
};
