<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('piese', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_categorie_piesa')->constrained('categorii_piese');
            $table->string('nume');
            $table->integer('cantitate')->default(0);
            $table->boolean('activ')->default(true);
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('piese');
    }
};
