<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modele', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_marca')->constrained('marci');
            $table->string('nume');
            $table->string('full_car_name'); // Full name of the car
            $table->string('car_id')->nullable(); // External car ID (assuming it's unique)
            $table->string('image_url')->nullable(); // Image URL for the car
            $table->string('engine_version')->nullable();
            $table->string('engine_subversion')->nullable();
            $table->date('model_launch_date')->nullable();
            $table->date('model_end_date')->nullable();
            $table->integer('power_kw')->nullable(); // Power in KW
            $table->integer('power_hp')->nullable(); // Power in HP
            $table->integer('displacement_ccm')->nullable(); // Displacement in ccm
            $table->string('hsn_key_number')->nullable(); // HSN Key Number
            $table->string('engine_type')->nullable();
            $table->string('engine_code')->nullable();
            $table->integer('max_output_kw_system')->nullable(); // Maximum output in kW (system output)
            $table->string('torque_system')->nullable(); // Torque (system performance)
            $table->integer('nominal_power_kw')->nullable(); // Nominal power in kW
            $table->string('drivetrain_type')->nullable();
            $table->string('gearbox_type')->nullable();
            $table->integer('number_of_gears')->nullable();
            $table->string('emission_category')->nullable();
            $table->string('exhaust_gas_cleaning')->nullable(); // Exhaust gas cleaning (combustion engine)
            $table->integer('number_of_cylinders')->nullable(); // Number of cylinders (combustion engine)
            $table->string('injection_type')->nullable(); // Injection type (internal combustion engine)
            $table->integer('number_of_valves')->nullable(); // Number of valves (combustion engine)
            $table->integer('displacement_combustion_engine')->nullable(); // Displacement (combustion engine)
            $table->string('power_torque_combustion_engine')->nullable(); // Power / torque (combustion engine)
            $table->integer('length_mm')->nullable(); // Length (mm)
            $table->integer('width_mm')->nullable(); // Width (mm)
            $table->integer('width_with_mirrors_mm')->nullable(); // Width including mirrors (mm)
            $table->integer('height_mm')->nullable(); // Height (mm)
            $table->integer('wheelbase_mm')->nullable(); // Wheelbase (mm)
            $table->integer('curb_weight_kg')->nullable(); // Curb weight (kg)
            $table->integer('gross_weight_kg')->nullable(); // Gross weight (kg)
            $table->integer('payload_kg')->nullable(); // Payload (kg)
            $table->string('body_type')->nullable();
            $table->integer('number_of_doors')->nullable();
            $table->string('number_of_sliding_doors')->nullable(); // Assuming this can be a string like "standard / option"
            $table->string('vehicle_class')->nullable();
            $table->integer('number_of_seats_normal')->nullable();
            $table->integer('number_of_seats_maximum')->nullable();
            $table->string('tire_size')->nullable();
            $table->string('tire_size_rear')->nullable(); // Tire size rear (if different)
            $table->integer('gas_tank_size')->nullable(); // Gas tank size
            $table->integer('gas_tank_size_2nd_drive')->nullable(); // Gas tank size (2nd drive)
            $table->decimal('battery_capacity_gross_kwh', 8, 2)->nullable(); // Battery capacity (gross) in kWh
            $table->decimal('battery_capacity_net_kwh', 8, 2)->nullable(); // Battery capacity (net) in kWh
            $table->integer('battery_weight_kg')->nullable(); // Battery weight (electric and plug-in hybrid)
            $table->integer('charging_power_kw')->nullable(); // Charging power (kW)
            $table->boolean('abs')->nullable();
            $table->boolean('activ')->default(true);
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modele');
    }
};
