<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categorii_piese', function (Blueprint $table) {
            $table->id();
            $table->string('nume');
            $table->boolean('activ')->default(true);
            $table->foreignId('id_parinte')->nullable()->constrained('categorii_piese');
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categorii_piese');
    }
};
