<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StocPiesa extends Model
{
    protected $table = 'stoc_piese';

    public function model()
    {
        return $this->belongsTo(ModelAuto::class, 'id_model');
    }

    public function masina()
    {
        return $this->belongsTo(StocMasina::class, 'id_stoc_masina');
    }

    public function piesa()
    {
        return $this->belongsTo(Piesa::class, 'id_piesa');
    }

    public function imagini()
    {
        return $this->hasMany(Imagine::class, 'id_piesa_stoc');
    }
}
