<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StocMasina extends Model
{
    protected $table = 'stoc_masini';

    public function marca()
    {
        return $this->belongsTo(Marca::class, 'id_marca');
    }

    public function model()
    {
        return $this->belongsTo(ModelAuto::class, 'id_model');
    }

    public function piese()
    {
        return $this->hasMany(StocPiesa::class, 'id_stoc_masina');
    }

    public function imagini()
    {
        return $this->hasMany(Imagine::class, 'id_masina_stoc');
    }
}
