<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ModelAuto extends Model
{
    protected $table = 'modele';

    public function marca()
    {
        return $this->belongsTo(Marca::class, 'id_marca');
    }

    public function masini()
    {
        return $this->hasMany(StocMasina::class, 'id_model');
    }

    public function stocuriPiese()
    {
        return $this->hasMany(StocPiesa::class, 'id_model');
    }
}
